/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

public class HttpPoolCleaner
implements Runnable {
    private final ClientConnectionManager connMgr;
    private long timeBetweenEvictionRunsMillis;
    private long minEvictableIdleTimeMillis;
    private volatile boolean shutdown;

    public HttpPoolCleaner(ClientConnectionManager connMgr, long timeBetweenEvictionRunsMillis, long minEvictableIdleTimeMillis) {
        this.connMgr = connMgr;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                HttpPoolCleaner httpPoolCleaner = this;
                synchronized (httpPoolCleaner) {
                    this.wait(this.timeBetweenEvictionRunsMillis);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(this.minEvictableIdleTimeMillis, TimeUnit.MILLISECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        HttpPoolCleaner httpPoolCleaner = this;
        synchronized (httpPoolCleaner) {
            this.notifyAll();
        }
    }
}

