/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.alarm;

import com.fasterxml.jackson.annotation.JsonCreator;
import monasca.common.util.stats.Statistic;
import monasca.common.util.stats.Statistics;

public enum AggregateFunction {
    MIN,
    MAX,
    SUM,
    COUNT,
    AVG;


    @JsonCreator
    public static AggregateFunction fromJson(String text) {
        return AggregateFunction.valueOf(text.toUpperCase());
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public Class<? extends Statistic> toStatistic() {
        if (AVG.equals((Object)this)) {
            return Statistics.Average.class;
        }
        if (COUNT.equals((Object)this)) {
            return Statistics.Count.class;
        }
        if (SUM.equals((Object)this)) {
            return Statistics.Sum.class;
        }
        if (MIN.equals((Object)this)) {
            return Statistics.Min.class;
        }
        if (MAX.equals((Object)this)) {
            return Statistics.Max.class;
        }
        return null;
    }
}

