/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.alarm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import monasca.common.model.alarm.AlarmExpressionErrorListener;
import monasca.common.model.alarm.AlarmExpressionLexer;
import monasca.common.model.alarm.AlarmExpressionParser;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.alarm.AlarmSubExpressionListener;
import monasca.common.model.alarm.BooleanExpression;
import monasca.common.model.alarm.BooleanOperator;
import monasca.common.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class AlarmExpression {
    private final String expression;
    private final List<Object> elements;
    private volatile List<AlarmSubExpression> subExpressions;

    public AlarmExpression(String expression) {
        this.expression = expression;
        AlarmExpressionParser parser = new AlarmExpressionParser((TokenStream)new CommonTokenStream((TokenSource)new AlarmExpressionLexer((CharStream)new ANTLRInputStream(expression))));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new AlarmExpressionErrorListener());
        parser.setBuildParseTree(true);
        AlarmExpressionParser.StartContext tree = parser.start();
        AlarmSubExpressionListener listener = new AlarmSubExpressionListener(false);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        this.elements = listener.getElements();
    }

    @JsonCreator
    public static AlarmExpression of(String expression) {
        return new AlarmExpression(expression);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlarmExpression other = (AlarmExpression)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public boolean evaluate(Map<AlarmSubExpression, Boolean> subExpressionValues) {
        Stack stack = new Stack();
        for (Object element : this.elements) {
            if (element instanceof AlarmSubExpression) {
                Boolean value = subExpressionValues.get(element);
                if (value == null) {
                    throw new IllegalArgumentException("Expected sub-expression was not found for " + element);
                }
                stack.push((Object)value);
                continue;
            }
            BooleanOperator operator = (BooleanOperator)((Object)element);
            Boolean operandA = (Boolean)stack.pop();
            Boolean operandB = (Boolean)stack.pop();
            stack.push((Object)operator.evaluate(operandA, operandB));
        }
        return (Boolean)stack.pop();
    }

    @JsonIgnore
    public String getExpression() {
        return this.expression;
    }

    @JsonIgnore
    public Object getExpressionTree() {
        Stack stack = new Stack();
        for (Object element : this.elements) {
            if (element instanceof AlarmSubExpression) {
                stack.push(element);
                continue;
            }
            BooleanOperator operator = (BooleanOperator)((Object)element);
            Object operandA = stack.pop();
            Object operandB = stack.pop();
            BooleanExpression expr = null;
            if (operandB instanceof BooleanExpression && ((BooleanExpression)operandB).operator.equals((Object)operator)) {
                expr = (BooleanExpression)operandB;
                expr.operands.add(operandA);
            } else {
                expr = new BooleanExpression(operator, operandB, operandA);
            }
            stack.push((Object)expr);
        }
        return stack.pop();
    }

    public List<AlarmSubExpression> getSubExpressions() {
        if (this.subExpressions != null) {
            return this.subExpressions;
        }
        ArrayList<AlarmSubExpression> subExpressions = new ArrayList<AlarmSubExpression>();
        for (Object element : this.elements) {
            if (!(element instanceof AlarmSubExpression)) continue;
            subExpressions.add((AlarmSubExpression)element);
        }
        this.subExpressions = subExpressions;
        return subExpressions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public String toString() {
        return String.format("AlarmExpression [elements=%s]", this.elements);
    }
}

