/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.alarm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmExpressionErrorListener;
import monasca.common.model.alarm.AlarmExpressionLexer;
import monasca.common.model.alarm.AlarmExpressionParser;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmSubExpressionListener;
import monasca.common.model.metric.MetricDefinition;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class AlarmSubExpression
implements Serializable {
    private static final long serialVersionUID = -7458129503846747592L;
    public static final int DEFAULT_PERIOD = 60;
    public static final int DEFAULT_PERIODS = 1;
    private AggregateFunction function;
    private MetricDefinition metricDefinition;
    private AlarmOperator operator;
    private double threshold;
    private int period;
    private int periods;

    public AlarmSubExpression(AggregateFunction function, MetricDefinition metricDefinition, AlarmOperator operator, double threshold, int period, int periods) {
        this.function = function;
        this.metricDefinition = metricDefinition;
        this.operator = operator;
        this.threshold = threshold;
        this.period = period;
        this.periods = periods;
    }

    AlarmSubExpression() {
    }

    @JsonCreator
    public static AlarmSubExpression of(String expression) {
        AlarmExpressionParser parser = new AlarmExpressionParser((TokenStream)new CommonTokenStream((TokenSource)new AlarmExpressionLexer((CharStream)new ANTLRInputStream(expression))));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new AlarmExpressionErrorListener());
        parser.setBuildParseTree(true);
        AlarmExpressionParser.StartContext tree = parser.start();
        AlarmSubExpressionListener listener = new AlarmSubExpressionListener(true);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        return (AlarmSubExpression)listener.getElements().get(0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlarmSubExpression other = (AlarmSubExpression)obj;
        if (this.function != other.function) {
            return false;
        }
        if (this.metricDefinition == null ? other.metricDefinition != null : !this.metricDefinition.equals(other.metricDefinition)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        if (this.periods != other.periods) {
            return false;
        }
        return Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(other.threshold);
    }

    public boolean evaluate(double value) {
        return this.operator.evaluate(value, this.threshold);
    }

    @JsonIgnore
    public String getExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.function).append('(').append(this.metricDefinition.toExpression());
        if (this.period != 60) {
            sb.append(", ").append(this.period);
        }
        sb.append(") ").append((Object)this.operator).append(' ').append(this.threshold);
        if (this.periods != 1) {
            sb.append(" times ").append(this.periods);
        }
        return sb.toString();
    }

    public AggregateFunction getFunction() {
        return this.function;
    }

    public MetricDefinition getMetricDefinition() {
        return this.metricDefinition;
    }

    public AlarmOperator getOperator() {
        return this.operator;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getPeriods() {
        return this.periods;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.metricDefinition == null ? 0 : this.metricDefinition.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + this.period;
        result = 31 * result + this.periods;
        long temp = Double.doubleToLongBits(this.threshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void setFunction(AggregateFunction function) {
        this.function = function;
    }

    public void setMetricDefinition(MetricDefinition metricDefinition) {
        this.metricDefinition = metricDefinition;
    }

    public void setOperator(AlarmOperator operator) {
        this.operator = operator;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setPeriods(int periods) {
        this.periods = periods;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public String toString() {
        return this.getExpression();
    }
}

