/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.metric;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import monasca.common.model.domain.common.AbstractEntity;

public class MetricDefinition
extends AbstractEntity
implements Serializable {
    private static final long serialVersionUID = -3074228641225201445L;
    public String name;
    public Map<String, String> dimensions;

    public MetricDefinition() {
    }

    public MetricDefinition(String name, @Nullable Map<String, String> dimensions) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.dimensions = dimensions;
    }

    public String toString() {
        return "MetricDefinition{name='" + this.name + '\'' + ", dimensions=" + this.dimensions + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)obj;
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public String toExpression() {
        StringBuilder b = new StringBuilder();
        b.append(this.name);
        if (this.dimensions != null && !this.dimensions.isEmpty()) {
            b.append(this.dimensions);
        }
        return b.toString();
    }
}

