/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model;

import java.util.HashMap;
import java.util.Map;
import monasca.common.model.ComputeServiceInfo;
import monasca.common.model.ObjectStoreServiceInfo;
import monasca.common.model.ServiceInfo;
import monasca.common.model.VolumeServiceInfo;

public class Services {
    public static final String COMPUTE_SERVICE = "hpcs.compute";
    public static final String VOLUME_SERVICE = "hpcs.volume";
    public static final String OBJECT_STORE_SERVICE = "hpcs.object-store";
    public static final String SERVICE_DIMENSION = "service";
    public static final Map<String, ServiceInfo> INFO = new HashMap<String, ServiceInfo>();
    public static final String RESERVED_SERVICE_PREFIX = "hpcs.";

    public static String getResourceIdDimension(String service) {
        ServiceInfo serviceInfo = INFO.get(service);
        return serviceInfo == null ? null : serviceInfo.getResourceIdDimension();
    }

    public static boolean isReserved(String service) {
        return service.toLowerCase().startsWith(RESERVED_SERVICE_PREFIX);
    }

    public static boolean isValidDimensionName(String service, String dimensionName) {
        ServiceInfo serviceInfo = INFO.get(service);
        return serviceInfo == null || serviceInfo.getSupportedDimensions().contains(dimensionName);
    }

    public static boolean isValidMetricName(String service, String metricName) {
        ServiceInfo serviceInfo = INFO.get(service);
        return serviceInfo == null || serviceInfo.getSupportedMetricNames().contains(metricName);
    }

    static {
        INFO.put(COMPUTE_SERVICE, new ComputeServiceInfo());
        INFO.put(VOLUME_SERVICE, new VolumeServiceInfo());
        INFO.put(OBJECT_STORE_SERVICE, new ObjectStoreServiceInfo());
    }
}

