/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.metric;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import monasca.common.model.metric.Metric;
import monasca.common.util.Exceptions;
import org.apache.commons.lang3.StringEscapeUtils;

public final class Metrics {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Metrics() {
    }

    public static Metric fromJson(byte[] metricJson) {
        try {
            String jsonStr = StringEscapeUtils.unescapeJava((String)new String(metricJson, "UTF-8"));
            return (Metric)OBJECT_MAPPER.readValue(jsonStr, Metric.class);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Exception)e, (String)"Failed to parse metric json: %s", (Object[])new Object[]{new String(metricJson)});
        }
    }

    public static String toJson(Metric metric) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)metric);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    static {
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new MetricSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
    }

    private static class MetricSerializer
    extends JsonSerializer<Metric> {
        private MetricSerializer() {
        }

        public Class<Metric> handledType() {
            return Metric.class;
        }

        public void serialize(Metric value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("name", value.name);
            if (value.dimensions != null && !value.dimensions.isEmpty()) {
                jgen.writeObjectField("dimensions", value.dimensions);
            }
            jgen.writeNumberField("timestamp", value.timestamp);
            jgen.writeNumberField("value", value.value);
            if (value.valueMeta != null && !value.valueMeta.isEmpty()) {
                jgen.writeObjectField("value_meta", value.valueMeta);
            }
            jgen.writeEndObject();
        }
    }
}

