/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.alarm;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmExpressionBaseListener;
import monasca.common.model.alarm.AlarmExpressionParser;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.alarm.BooleanOperator;
import monasca.common.model.metric.MetricDefinition;

class AlarmSubExpressionListener
extends AlarmExpressionBaseListener {
    private final boolean simpleExpression;
    private AggregateFunction function;
    private String namespace;
    private SortedMap<String, String> dimensions = new TreeMap<String, String>();
    private AlarmOperator operator;
    private double threshold;
    private int period = 60;
    private int periods = 1;
    private List<Object> elements = new ArrayList<Object>();
    private boolean deterministic = false;

    AlarmSubExpressionListener(boolean simpleExpression) {
        this.simpleExpression = simpleExpression;
    }

    private void saveSubExpression() {
        MetricDefinition metricDefinition = new MetricDefinition(this.namespace, this.dimensions);
        AlarmSubExpression subExpression = new AlarmSubExpression(this.function, metricDefinition, this.operator, this.threshold, this.period, this.periods, this.deterministic);
        this.elements.add(subExpression);
        this.function = null;
        this.namespace = null;
        this.dimensions = new TreeMap<String, String>();
        this.operator = null;
        this.threshold = 0.0;
        this.period = 60;
        this.periods = 1;
        this.deterministic = false;
    }

    @Override
    public void exitRelationalExprFwd(AlarmExpressionParser.RelationalExprFwdContext ctx) {
        this.function = this.operator == AlarmOperator.GT || this.operator == AlarmOperator.GTE ? AggregateFunction.MAX : AggregateFunction.MIN;
        this.saveSubExpression();
    }

    @Override
    public void exitRelationalExprFuncFwd(AlarmExpressionParser.RelationalExprFuncFwdContext ctx) {
        this.saveSubExpression();
    }

    @Override
    public void enterFunctionType(AlarmExpressionParser.FunctionTypeContext ctx) {
        this.function = AggregateFunction.valueOf(ctx.getChild(0).getText().toUpperCase());
    }

    @Override
    public void enterNamespace(AlarmExpressionParser.NamespaceContext ctx) {
        this.namespace = ctx.getChild(0).getText();
    }

    @Override
    public void enterDimension(AlarmExpressionParser.DimensionContext ctx) {
        StringBuilder dimensionName = new StringBuilder();
        dimensionName.append(ctx.getChild(0).getText());
        int i = 1;
        while (!ctx.getChild(i).getText().equals("=")) {
            dimensionName.append(' ');
            dimensionName.append(ctx.getChild(i).getText());
            ++i;
        }
        StringBuilder dimensionValue = new StringBuilder();
        dimensionValue.append(ctx.getChild(++i).getText());
        ++i;
        while (i < ctx.getChildCount()) {
            dimensionValue.append(' ');
            dimensionValue.append(ctx.getChild(i).getText());
            ++i;
        }
        if (this.dimensions.put(dimensionName.toString(), dimensionValue.toString()) != null) {
            throw new IllegalArgumentException("More than one value was given for dimension " + dimensionName);
        }
    }

    @Override
    public void enterPeriod(AlarmExpressionParser.PeriodContext ctx) {
        this.period = Integer.valueOf(ctx.getChild(0).getText());
    }

    @Override
    public void enterRepeat(AlarmExpressionParser.RepeatContext ctx) {
        this.periods = Integer.valueOf(ctx.getChild(0).getText());
    }

    @Override
    public void enterLt(AlarmExpressionParser.LtContext ctx) {
        this.assertSimpleExpression();
        this.operator = AlarmOperator.LT;
    }

    @Override
    public void enterLte(AlarmExpressionParser.LteContext ctx) {
        this.assertSimpleExpression();
        this.operator = AlarmOperator.LTE;
    }

    @Override
    public void enterGt(AlarmExpressionParser.GtContext ctx) {
        this.assertSimpleExpression();
        this.operator = AlarmOperator.GT;
    }

    @Override
    public void enterGte(AlarmExpressionParser.GteContext ctx) {
        this.assertSimpleExpression();
        this.operator = AlarmOperator.GTE;
    }

    @Override
    public void exitLiteral(AlarmExpressionParser.LiteralContext ctx) {
        this.threshold = Double.valueOf(ctx.getChild(0).getText());
    }

    @Override
    public void exitOrExpr(AlarmExpressionParser.OrExprContext ctx) {
        this.elements.add((Object)BooleanOperator.OR);
    }

    @Override
    public void exitAndExpr(AlarmExpressionParser.AndExprContext ctx) {
        this.elements.add((Object)BooleanOperator.AND);
    }

    @Override
    public void enterDeterministic(AlarmExpressionParser.DeterministicContext ctx) {
        this.deterministic = true;
    }

    List<Object> getElements() {
        return this.elements;
    }

    private void assertSimpleExpression() {
        if (this.simpleExpression && !this.elements.isEmpty()) {
            throw new IllegalArgumentException("Expected a simple expression");
        }
    }
}

