/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.model.metric;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import monasca.common.model.metric.MetricDefinition;

public class Metric
implements Serializable {
    private static final long serialVersionUID = 3455749495426525634L;
    public String name;
    public Map<String, String> dimensions;
    public long timestamp;
    public double value;
    public Map<String, String> valueMeta;
    private MetricDefinition definition;

    public Metric() {
    }

    public Metric(@NotNull MetricDefinition definition, long timestamp, double value, @Nullable Map<String, String> valueMeta) {
        this.definition = (MetricDefinition)Preconditions.checkNotNull((Object)definition, (Object)"definition");
        this.name = definition.name;
        this.setDimensions(definition.dimensions);
        this.timestamp = timestamp;
        this.value = value;
        this.valueMeta = valueMeta;
    }

    public Metric(String name, @Nullable Map<String, String> dimensions, long timestamp, double value, @Nullable Map<String, String> valueMeta) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.setDimensions(dimensions);
        this.timestamp = timestamp;
        this.value = value;
        this.valueMeta = valueMeta;
    }

    public MetricDefinition definition() {
        if (this.definition == null) {
            this.definition = new MetricDefinition(this.name, this.dimensions);
        }
        return this.definition;
    }

    public String toString() {
        return "Metric{name='" + this.name + '\'' + ", dimensions=" + this.dimensions + ", timestamp=" + this.timestamp + ", value=" + this.value + ", valueMeta=" + this.valueMeta + ", definition=" + this.definition + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.valueMeta == null ? other.valueMeta != null : !this.valueMeta.equals(other.valueMeta)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.valueMeta == null ? 0 : this.valueMeta.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Map<String, String> getValueMeta() {
        return this.valueMeta;
    }

    public void setValueMeta(Map<String, String> valueMeta) {
        this.valueMeta = valueMeta;
    }
}

