/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.persistence;

import java.util.List;
import java.util.Map;

public final class SqlStatements {
    private SqlStatements() {
    }

    public static String unionAllStatementFor(Map<String, String> keyValues, String keyFieldName, String valueFieldName) {
        StringBuilder sb = new StringBuilder();
        int propertyCount = 0;
        for (Map.Entry<String, String> kvEntry : keyValues.entrySet()) {
            if (propertyCount != 0) {
                sb.append(" union all ");
            }
            sb.append("select '").append(kvEntry.getKey()).append("' ").append(keyFieldName).append(", '").append(kvEntry.getValue()).append("' ").append(valueFieldName);
            ++propertyCount;
        }
        return sb.toString();
    }

    public static String unionStatementFor(List<String> values, String valueFieldName) {
        StringBuilder sb = new StringBuilder();
        int propertyCount = 0;
        for (String value : values) {
            if (propertyCount != 0) {
                sb.append(" union ");
            }
            sb.append("select '").append(value).append("' ").append(valueFieldName);
            ++propertyCount;
        }
        return sb.toString();
    }
}

