/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.persistence;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class BeanMapper<T>
implements ResultSetMapper<T> {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();

    public BeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                this.properties.put(descriptor.getName(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String pascalCaseToCamelCase(String str) {
        StringBuilder sb = new StringBuilder();
        String[] tokens = str.split("_");
        for (int i = 0; i < tokens.length; ++i) {
            String s = tokens[i];
            char c = s.charAt(0);
            sb.append(i == 0 ? Character.toLowerCase(c) : Character.toUpperCase(c));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
        }
        return sb.toString();
    }

    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String commaStr;
            Timestamp ts;
            String name = BeanMapper.pascalCaseToCamelCase(metadata.getColumnLabel(i).toLowerCase());
            PropertyDescriptor descriptor = this.properties.get(name);
            if (descriptor == null) continue;
            Class<Object> type = descriptor.getPropertyType();
            Object value = type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(rs.getBoolean(i)) : (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE) ? Byte.valueOf(rs.getByte(i)) : (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE) ? Short.valueOf(rs.getShort(i)) : (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(rs.getInt(i)) : (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) ? (metadata.getColumnType(i) == 93 ? Long.valueOf(rs.getTimestamp(i).getTime()) : Long.valueOf(rs.getLong(i))) : (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) ? Float.valueOf(rs.getFloat(i)) : (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) ? Double.valueOf(rs.getDouble(i)) : (type.isAssignableFrom(BigDecimal.class) ? rs.getBigDecimal(i) : (type.isAssignableFrom(Timestamp.class) ? rs.getTimestamp(i) : (type.isAssignableFrom(Time.class) ? rs.getTime(i) : (type.isAssignableFrom(Date.class) ? rs.getDate(i) : (type.isAssignableFrom(DateTime.class) ? ((ts = rs.getTimestamp(i)) == null ? null : new DateTime(ts.getTime(), DateTimeZone.UTC)) : (type.isAssignableFrom(String.class) ? (metadata.getColumnType(i) == 93 ? DATETIME_FORMATTER.print(rs.getTimestamp(i).getTime()) : rs.getString(i)) : (type.isAssignableFrom(List.class) ? (Strings.isNullOrEmpty((String)(commaStr = rs.getString(i))) ? Collections.emptyList() : COMMA_SPLITTER.splitToList((CharSequence)commaStr)) : rs.getObject(i))))))))))))));
            if (rs.wasNull() && !type.isPrimitive()) {
                value = null;
            }
            if (type.isEnum() && value != null) {
                value = Enum.valueOf(type, (String)value);
            }
            try {
                descriptor.getWriteMethod().invoke(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("No appropriate method to write value %s ", value.toString()), e);
            }
        }
        return bean;
    }
}

