/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.streaming.storm;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.generated.StormTopology;
import com.google.common.base.Preconditions;
import java.util.Map;
import monasca.common.util.Injector;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class TopologyTestCase {
    public static final String TEST_TOPOLOGY_NAME = "test-maas-alarming";
    protected static volatile LocalCluster cluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startTopology() throws Exception {
        if (cluster != null) return;
        Class<TopologyTestCase> clazz = TopologyTestCase.class;
        synchronized (TopologyTestCase.class) {
            if (cluster != null) return;
            Preconditions.checkArgument((boolean)Injector.isBound(Config.class), (Object)"You must bind a storm config");
            Preconditions.checkArgument((boolean)Injector.isBound(StormTopology.class), (Object)"You must bind a storm topology");
            cluster = new LocalCluster();
            cluster.submitTopology(TEST_TOPOLOGY_NAME, (Map)Injector.getInstance(Config.class), (StormTopology)Injector.getInstance(StormTopology.class));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static void stopTopology() {
        if (cluster != null) {
            cluster.killTopology(TEST_TOPOLOGY_NAME);
            cluster.shutdown();
            cluster = null;
        }
    }
}

