/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util.stats;

import javax.annotation.concurrent.NotThreadSafe;
import monasca.common.util.Exceptions;
import monasca.common.util.stats.Statistic;
import monasca.common.util.time.TimeResolution;

@NotThreadSafe
public class SlidingWindowStats {
    private final TimeResolution timescale;
    private final long slotWidth;
    private final int numViewSlots;
    private final long windowLength;
    private final Slot[] slots;
    private int windowBeginIndex;
    private long viewEndTimestamp;
    private long slotEndTimestamp;
    private long windowEndTimestamp;

    public SlidingWindowStats(Class<? extends Statistic> statType, TimeResolution timeResolution, long slotWidth, int numViewSlots, int numFutureSlots, long viewEndTimestamp) {
        this.timescale = timeResolution;
        this.slotWidth = slotWidth;
        this.numViewSlots = numViewSlots;
        this.windowLength = (long)(numViewSlots + numFutureSlots) * slotWidth;
        this.slotEndTimestamp = this.viewEndTimestamp = timeResolution.adjust(viewEndTimestamp);
        this.windowEndTimestamp = this.viewEndTimestamp + (long)numFutureSlots * slotWidth;
        this.slots = new Slot[numViewSlots + numFutureSlots];
        long timestamp = this.windowEndTimestamp - slotWidth;
        int i = numViewSlots + numFutureSlots - 1;
        while (i > -1) {
            this.slots[i] = SlidingWindowStats.createSlot(timestamp, statType);
            --i;
            timestamp -= slotWidth;
        }
    }

    private static Slot createSlot(long timestamp, Class<? extends Statistic> statType) {
        try {
            return new Slot(timestamp, statType.newInstance());
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to initialize slot", new Object[0]);
        }
    }

    public boolean addValue(double value, long timestamp) {
        int index = this.indexOfTime(timestamp = this.timescale.adjust(timestamp));
        if (index == -1) {
            return false;
        }
        this.slots[index].stat.addValue(value);
        return true;
    }

    public int getSlotCount() {
        return this.slots.length;
    }

    public long getSlotWidth() {
        return this.slotWidth;
    }

    public long[] getTimestamps() {
        long[] timestamps = new long[this.numViewSlots];
        long timestamp = this.windowEndTimestamp - (long)(this.slots.length - 1) * this.slotWidth;
        int i = 0;
        while (i < this.numViewSlots) {
            timestamps[i] = timestamp;
            ++i;
            timestamp += this.slotWidth;
        }
        return timestamps;
    }

    public double getValue(long timestamp) {
        int index = this.indexOfTime(timestamp = this.timescale.adjust(timestamp));
        if (index == -1) {
            throw new IllegalStateException(timestamp + " is outside of the window");
        }
        return this.slots[index].stat.value();
    }

    public double[] getValuesUpTo(long timestamp) {
        int endIndex = this.indexOfTime(timestamp = this.timescale.adjust(timestamp));
        if (endIndex == -1) {
            throw new IllegalStateException(timestamp + " is outside of the window");
        }
        double[] values = new double[this.lengthToIndex(endIndex)];
        int index = this.windowBeginIndex;
        for (int i = 0; i < values.length; ++i) {
            if (this.slots[index] != null) {
                values[i] = this.slots[index].stat.value();
            }
            index = this.indexAfter(index);
        }
        return values;
    }

    public double[] getViewValues() {
        double[] values = new double[this.numViewSlots];
        int index = this.windowBeginIndex;
        for (int i = 0; i < this.numViewSlots; ++i) {
            if (this.slots[index] != null) {
                values[i] = this.slots[index].stat.value();
            }
            index = this.indexAfter(index);
        }
        return values;
    }

    public double[] getWindowValues() {
        double[] values = new double[this.slots.length];
        int index = this.windowBeginIndex;
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[index] != null) {
                values[i] = this.slots[index].stat.value();
            }
            index = this.indexAfter(index);
        }
        return values;
    }

    public boolean shouldEvaluate(long timestamp, long minDelay) {
        return timestamp > this.viewEndTimestamp + minDelay;
    }

    public void slideViewTo(long timestamp, long minDelay) {
        if (timestamp <= this.viewEndTimestamp + minDelay) {
            return;
        }
        long timeDiff = timestamp - this.slotEndTimestamp;
        int slotsToAdvance = (int)(timeDiff / this.slotWidth);
        slotsToAdvance += timeDiff % this.slotWidth == 0L ? 0 : 1;
        for (int i = 0; i < slotsToAdvance; ++i) {
            this.windowBeginIndex = this.indexAfter(this.windowBeginIndex);
            Slot slot = this.slots[this.indexOf(this.slots.length - 1)];
            slot.timestamp = this.windowEndTimestamp;
            slot.stat.reset();
            this.slotEndTimestamp += this.slotWidth;
            this.windowEndTimestamp += this.slotWidth;
        }
        this.viewEndTimestamp += (long)slotsToAdvance * this.slotWidth;
    }

    public String toString() {
        int startIndex;
        int viewSlotsToDisplay = 3;
        StringBuilder b = new StringBuilder();
        b.append("SlidingWindowStats ");
        b.append(String.format("timescale = %s slotWidth = %d viewEndTimestamp = %d slotEndTimestamp = %d [(", new Object[]{this.timescale, this.slotWidth, this.viewEndTimestamp, this.slotEndTimestamp}));
        int n = startIndex = this.numViewSlots > 3 ? this.numViewSlots - 3 : 0;
        if (startIndex != 0) {
            b.append("... ");
        }
        int index = this.indexOf(startIndex);
        for (int i = startIndex; i < this.slots.length; ++i) {
            if (i == this.numViewSlots) {
                b.append("), ");
            } else if (i != startIndex) {
                b.append(", ");
            }
            b.append(this.slots[index]);
            index = this.indexAfter(index);
        }
        return b.append(']').toString();
    }

    int indexOf(int slotIndex) {
        int offset = this.windowBeginIndex + slotIndex;
        if (offset >= this.slots.length) {
            offset -= this.slots.length;
        }
        return offset;
    }

    int indexOfTime(long timestamp) {
        long windowStartTimestamp;
        int timeDiff;
        if (timestamp < this.windowEndTimestamp && (timeDiff = (int)(timestamp - (windowStartTimestamp = this.windowEndTimestamp - this.windowLength))) >= 0) {
            int logicalIndex = (int)((long)timeDiff / this.slotWidth);
            return this.indexOf(logicalIndex);
        }
        return -1;
    }

    int lengthToIndex(int slotIndex) {
        if (this.windowBeginIndex <= slotIndex) {
            return slotIndex - this.windowBeginIndex + 1;
        }
        return slotIndex + this.slots.length - this.windowBeginIndex + 1;
    }

    private int indexAfter(int index) {
        return ++index == this.slots.length ? 0 : index;
    }

    private static class Slot {
        private long timestamp;
        private Statistic stat;

        private Slot(long timestamp, Statistic stat) {
            this.timestamp = timestamp;
            this.stat = stat;
        }

        public String toString() {
            return this.timestamp + "=" + this.stat;
        }
    }
}

