/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util;

import java.util.Arrays;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class Conversions {
    private static final String[] SUPPORTED_VARIANT_TO_ENUM_TYPES = new String[]{String.class.getSimpleName(), Number.class.getSimpleName(), Enum.class.getSimpleName()};

    public static Integer variantToInteger(Object variant) {
        if (variant instanceof Number) {
            return ((Number)variant).intValue();
        }
        throw new IllegalArgumentException(String.format("Variant of type \"%s\", and value \"%s\" is not a Number.", variant.getClass(), variant));
    }

    public static DateTime variantToDateTime(Object variant) {
        return Conversions.variantToDateTime(variant, DateTimeZone.UTC);
    }

    public static DateTime variantToDateTime(Object variant, DateTimeZone timeZone) {
        if (variant instanceof DateTime) {
            return ((DateTime)variant).toDateTime(timeZone);
        }
        return new DateTime(variant, timeZone);
    }

    public static <T extends Enum<T>> T variantToEnum(Object variant, Class<T> enumClazz) {
        if (variant == null) {
            return null;
        }
        if (variant instanceof String) {
            return Enum.valueOf(enumClazz, ((String)variant).trim().toUpperCase());
        }
        if (variant instanceof Number) {
            Integer index = Conversions.variantToInteger(variant);
            Enum[] enumConstants = (Enum[])enumClazz.getEnumConstants();
            if (index < 0 || index >= enumConstants.length) {
                throw new IllegalArgumentException(String.format("Variant of type \"%s\", and value \"%s\" is out of range [, %d]", variant.getClass(), variant, enumConstants.length));
            }
            return (T)enumConstants[index];
        }
        if (variant instanceof Enum) {
            return (T)((Enum)variant);
        }
        throw new IllegalArgumentException(String.format("\"%s\", and value \"%s\" is not one of %s", variant.getClass(), variant, Arrays.toString(SUPPORTED_VARIANT_TO_ENUM_TYPES)));
    }

    public static Boolean variantToBoolean(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        return "1".equals(input.toString());
    }
}

