/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Configurations {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    private Configurations() {
    }

    public static Map<String, String> configFor(String keyPrefix, Object source) {
        HashMap<String, String> config = new HashMap<String, String>();
        Configurations.buildConfigFor(keyPrefix, config, new ObjectMapper().valueToTree(source));
        return config;
    }

    private static void buildConfigFor(String path, Map<String, String> config, JsonNode node) {
        Iterator i = node.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            if (field.getValue() instanceof ValueNode) {
                ValueNode valueNode = (ValueNode)field.getValue();
                config.put(DOT_JOINER.join((Object)path, field.getKey(), new Object[0]), valueNode.asText());
            } else if (field.getValue() instanceof ArrayNode) {
                StringBuilder combinedValue = new StringBuilder();
                ArrayNode arrayNode = (ArrayNode)field.getValue();
                Iterator it = arrayNode.elements();
                while (it.hasNext()) {
                    String value = ((JsonNode)it.next()).asText().replaceAll("^\"|\"$", "");
                    if (combinedValue.length() > 0) {
                        combinedValue.append(',');
                    }
                    combinedValue.append(value);
                }
                config.put(DOT_JOINER.join((Object)path, field.getKey(), new Object[0]), combinedValue.toString());
            }
            Configurations.buildConfigFor(DOT_JOINER.join((Object)path, field.getKey(), new Object[0]), config, (JsonNode)field.getValue());
        }
    }
}

