/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util.stats;

import monasca.common.util.stats.Statistic;

public final class Statistics {
    private Statistics() {
    }

    public static class Last
    extends AbstractStatistic {
        protected double lastTimestamp;

        @Override
        public void addValue(double value, double timestamp) {
            this.initialized = true;
            if (timestamp > this.lastTimestamp) {
                this.value = value;
                this.lastTimestamp = timestamp;
            }
        }
    }

    public static class Sum
    extends AbstractStatistic {
        @Override
        public void addValue(double value, double timestamp) {
            this.initialized = true;
            this.value += value;
        }
    }

    public static class Min
    extends AbstractStatistic {
        @Override
        public void addValue(double value, double timestamp) {
            if (!this.initialized) {
                this.initialized = true;
                this.value = value;
            } else if (value < this.value) {
                this.value = value;
            }
        }
    }

    public static class Max
    extends AbstractStatistic {
        @Override
        public void addValue(double value, double timestamp) {
            if (!this.initialized) {
                this.initialized = true;
                this.value = value;
            } else if (value > this.value) {
                this.value = value;
            }
        }
    }

    public static class Count
    extends AbstractStatistic {
        @Override
        public void addValue(double value, double timestamp) {
            this.initialized = true;
            this.value += 1.0;
        }
    }

    public static class Average
    extends Sum {
        protected int count;

        @Override
        public void addValue(double value, double timestamp) {
            super.addValue(value, timestamp);
            ++this.count;
        }

        @Override
        public void reset() {
            super.reset();
            this.count = 0;
        }

        @Override
        public double value() {
            return !this.initialized ? Double.NaN : (this.count == 0 ? 0.0 : this.value / (double)this.count);
        }
    }

    public static abstract class AbstractStatistic
    implements Statistic {
        protected boolean initialized;
        protected double value;

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        @Override
        public void reset() {
            this.initialized = false;
            this.value = 0.0;
        }

        public String toString() {
            return Double.valueOf(this.value()).toString();
        }

        @Override
        public double value() {
            return !this.initialized ? Double.NaN : this.value;
        }
    }
}

