/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import monasca.common.util.config.ConfigurationException;
import monasca.common.util.validation.Validator;

public class ConfigurationFactory<T> {
    private final Class<T> configType;
    private final ObjectMapper mapper;

    private ConfigurationFactory(Class<T> configType) {
        this.configType = configType;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static <T> ConfigurationFactory<T> forClass(Class<T> configType) {
        return new ConfigurationFactory<T>(configType);
    }

    public T build(File file) throws IOException, ConfigurationException {
        JsonNode node = this.mapper.readTree(file);
        String filename = file.toString();
        return this.build(node, filename);
    }

    private T build(JsonNode node, String filename) throws IOException, ConfigurationException {
        Object config = this.mapper.readValue((JsonParser)new TreeTraversingParser(node), this.configType);
        this.validate(filename, config);
        return (T)config;
    }

    private void validate(String file, T config) throws ConfigurationException {
        ImmutableList<String> errors = new Validator().validate(config);
        if (!errors.isEmpty()) {
            throw new ConfigurationException(file, (Iterable<String>)errors);
        }
    }
}

