/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;

public final class Injector {
    private static volatile com.google.inject.Injector injector;

    private Injector() {
    }

    public static void checkInjectable(Class<?> type) {
        Injector.initInjector();
        injector.getBinding(type);
    }

    public static <T> T getInstance(Class<T> type) {
        Injector.initInjector();
        return (T)injector.getInstance(type);
    }

    public static <T> T getInstance(Class<T> type, String name) {
        Injector.initInjector();
        return (T)injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
    }

    public static <T> T getInstance(Key<T> key) {
        Injector.initInjector();
        return (T)injector.getInstance(key);
    }

    public static void injectMembers(Object object) {
        Injector.initInjector();
        injector.injectMembers(object);
    }

    public static boolean isBound(Class<?> type) {
        return injector != null && injector.getExistingBinding(Key.get(type)) != null;
    }

    public static boolean isBound(Class<?> type, String name) {
        return injector != null && injector.getExistingBinding(Key.get(type, (Annotation)Names.named((String)name))) != null;
    }

    public static synchronized void registerIfNotBound(Class<?> type, Module ... modules) {
        if (!Injector.isBound(type)) {
            Injector.registerModules(modules);
        }
    }

    public static synchronized void registerModules(Module ... modules) {
        injector = injector == null ? Guice.createInjector((Module[])modules) : injector.createChildInjector(modules);
    }

    public static void reset() {
        injector = null;
    }

    private static void initInjector() {
        if (injector == null) {
            Injector.registerModules(new Module[]{new AbstractModule(){

                protected void configure() {
                }
            }});
        }
    }
}

