/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.util.Map;
import monasca.common.util.Exceptions;
import monasca.common.util.Injector;
import monasca.common.util.Types;

public final class Serialization {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final InternalObjectMapper rootMapper = new InternalObjectMapper();
    static final Map<String, Class<?>> targetTypes = Maps.newHashMap();

    private Serialization() {
    }

    public static <T> T fromJson(byte[] json) {
        JsonNode node = null;
        try {
            node = mapper.readTree(json);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to deserialize json: {}", new Object[]{json});
        }
        return Serialization.fromJson(node);
    }

    public static <T> T fromJson(JsonNode node) {
        Preconditions.checkArgument((node.size() == 1 ? 1 : 0) != 0, (String)"The node must contain a single root key: %s", (Object[])new Object[]{node});
        String rootKey = (String)node.fieldNames().next();
        Class<?> targetType = targetTypes.get(rootKey);
        if (targetType == null) {
            throw new IllegalStateException("No target type is registered for the root key " + rootKey);
        }
        if (targetType.isPrimitive() || Primitives.isWrapperType(targetType)) {
            try {
                return (T)rootMapper.reader(targetType).readValue(node);
            }
            catch (IOException e) {
                throw Exceptions.uncheck(e, "Failed to deserialize json: {}", node);
            }
        }
        Object object = Injector.getInstance(targetType);
        Serialization.injectMembers(object, node);
        return (T)object;
    }

    public static <T> T fromJson(JsonNode node, Class<T> targetType) {
        T object = Injector.getInstance(targetType);
        Serialization.injectMembers(object, node);
        return object;
    }

    public static <T> T fromJson(JsonParser jsonParser) {
        JsonNode node = null;
        try {
            node = (JsonNode)mapper.readTree(jsonParser);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to deserialize json: {}", jsonParser);
        }
        return Serialization.fromJson(node);
    }

    public static <T> T fromJson(String json) {
        JsonNode node = null;
        try {
            node = mapper.readTree(json);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to deserialize json: {}", json);
        }
        return Serialization.fromJson(node);
    }

    public static <T> T fromJson(String json, Class<T> targetType) {
        try {
            return (T)rootMapper.readValue(json, targetType);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to deserialize json: {}", json);
        }
    }

    public static void injectMembers(Object object, JsonNode jsonNode) {
        try {
            rootMapper.readerForUpdating(object).readValue(jsonNode);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to inject members with json: {}", jsonNode);
        }
    }

    public static void registerTarget(Class<?> targetType) {
        targetTypes.put(Serialization.rootNameFor(targetType), targetType);
    }

    public static void registerTarget(String name, Class<?> targetType) {
        targetTypes.put(name, targetType);
    }

    public static String toJson(JsonNode node) {
        try {
            ObjectWriter writer = mapper.writer();
            return writer.writeValueAsString((Object)node);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to serialize object: {}", node);
        }
    }

    public static String toJson(Object object) {
        Class unwrappedType = Types.deProxy(object.getClass());
        Serialization.registerTarget(unwrappedType);
        try {
            ObjectWriter writer = rootMapper.writerWithType(unwrappedType);
            return writer.writeValueAsString(object);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to serialize object: {}", object);
        }
    }

    public static JsonNode toJsonNode(Object object) {
        try {
            ObjectNode rootNode = mapper.createObjectNode();
            JsonNode node = mapper.valueToTree(object);
            rootNode.put(Serialization.rootNameFor(Types.deProxy(object.getClass())), node);
            return rootNode;
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to serialize object: {}", object);
        }
    }

    public static JsonNode toJsonNode(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e, "Failed to deserialize json: {}", json);
        }
    }

    private static String rootNameFor(Class<?> type) {
        JsonRootName rootName = type.getAnnotation(JsonRootName.class);
        return rootName == null ? type.getSimpleName() : rootName.value();
    }

    static {
        mapper.setVisibilityChecker(mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        rootMapper.setVisibilityChecker(rootMapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        SimpleModule module = new SimpleModule("SerialiationModule");
        module.addSerializer((JsonSerializer)new DateTimeSerializer());
        mapper.registerModule((Module)module);
        rootMapper.registerModule((Module)module);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        rootMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        rootMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        rootMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        rootMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        rootMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    static class InternalObjectReader
    extends ObjectReader {
        private static final long serialVersionUID = 1L;

        protected InternalObjectReader(ObjectMapper mapper, DeserializationConfig config, JavaType valueType, Object valueToUpdate, InjectableValues injectableValues) {
            super(mapper, config, valueType, valueToUpdate, null, injectableValues);
        }
    }

    static class InternalObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 1L;

        InternalObjectMapper() {
        }

        public ObjectReader readerForUpdating(Object valueToUpdate) {
            JavaType t = this._typeFactory.constructType(Types.deProxy(valueToUpdate.getClass()));
            return new InternalObjectReader(this, this.getDeserializationConfig(), t, valueToUpdate, this._injectableValues);
        }
    }

    public static class Serializer
    extends JsonSerializer<Object> {
        public void serialize(Object object, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            Serialization.registerTarget(Types.deProxy(object.getClass()));
            jgen.writeObject(object);
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Serialization.fromJson(jsonParser);
        }
    }
}

