/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.util.concurrent;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import monasca.common.util.concurrent.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final Meter requestRate;
    private final Meter rejectedRate;
    private final Timer executionTimer;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final Set<ExecutionListener> listeners = new HashSet<ExecutionListener>();

    InstrumentedThreadPoolExecutor(MetricRegistry metricRegistry, String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, final BlockingQueue<Runnable> workQueue, ThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
        this.name = name;
        this.requestRate = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "request"}));
        this.rejectedRate = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "rejected"}));
        this.executionTimer = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "execution"}));
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "queue.size"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedThreadPoolExecutor.this.getQueue().size();
            }
        });
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "threads.count"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedThreadPoolExecutor.this.getPoolSize();
            }
        });
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "threads.active"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedThreadPoolExecutor.this.getActiveCount();
            }
        });
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "threads.idle"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedThreadPoolExecutor.this.getPoolSize() - InstrumentedThreadPoolExecutor.this.getActiveCount();
            }
        });
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{name, "threads.percent-active"}), (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)InstrumentedThreadPoolExecutor.this.getPoolSize(), (double)InstrumentedThreadPoolExecutor.this.getActiveCount());
            }
        });
        this.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                InstrumentedThreadPoolExecutor.this.rejectedRate.mark();
                if (!workQueue.offer(r)) {
                    InstrumentedThreadPoolExecutor.this.log.warn("Thread pool {} rejected work.", (Object)InstrumentedThreadPoolExecutor.this.name);
                }
                throw new RejectedExecutionException();
            }
        });
    }

    public void addListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void execute(Runnable r) {
        this.requestRate.mark();
        super.execute(r);
    }

    public void removeListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        for (ExecutionListener listener : this.listeners) {
            listener.afterExecute(r, t);
        }
        long duration = System.nanoTime() - this.startTime.get();
        this.executionTimer.update(duration, TimeUnit.NANOSECONDS);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        for (ExecutionListener listener : this.listeners) {
            listener.beforeExecute(t, r);
        }
        this.startTime.set(System.nanoTime());
    }
}

