/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import monasca.log.api.ApiConfig;
import monasca.log.api.app.LogSerializer;
import monasca.log.api.app.unload.JsonPayloadTransformer;
import monasca.log.api.app.validation.DimensionValidation;
import monasca.log.api.app.validation.LogApplicationTypeValidator;
import monasca.log.api.common.LogApiConstants;
import monasca.log.api.common.LogRequestBean;
import monasca.log.api.common.PayloadTransformer;
import monasca.log.api.model.Log;
import monasca.log.api.model.LogEnvelope;
import monasca.log.api.resource.exception.Exceptions;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogService.class);
    private static final Comparator<Map.Entry<String, String>> DIMENSIONS_COMPARATOR = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            int nameCmp = o1.getKey().compareTo(o2.getKey());
            return nameCmp != 0 ? nameCmp : o1.getValue().compareTo(o2.getValue());
        }
    };
    protected ApiConfig config;
    protected Producer<String, String> producer;
    protected LogSerializer serializer;
    protected Map<MediaType, PayloadTransformer> payloadTransformers;

    @Inject
    public LogService(ApiConfig config, Producer<String, String> producer, LogSerializer logSerializer) {
        this.config = config;
        this.producer = producer;
        this.serializer = logSerializer;
        this.payloadTransformers = Maps.newHashMapWithExpectedSize((int)2);
    }

    protected LogService() {
        this(null, null, null);
    }

    @Inject
    public void setJsonPayloadTransformer(JsonPayloadTransformer jsonPayloadTransformer) {
        this.payloadTransformers.put(MediaType.APPLICATION_JSON_TYPE, jsonPayloadTransformer);
    }

    public Log newLog(LogRequestBean logRequestBean) {
        LOGGER.debug(LogApiConstants.LOG_MARKER, "Creating new log from bean = {}", (Object)logRequestBean);
        return this.newLog(logRequestBean, true);
    }

    public Log newLog(LogRequestBean logRequestBean, boolean validate) {
        Log log;
        LOGGER.debug(LogApiConstants.LOG_MARKER, "Creating new log from bean = {}, validation is {}", (Object)logRequestBean, (Object)(validate ? "enabled" : "disabled"));
        Preconditions.checkNotNull((Object)logRequestBean, (Object)"LogBean must not be null");
        Preconditions.checkNotNull((Object)logRequestBean.getPayload(), (Object)"Payload should not be null");
        String payload = logRequestBean.getPayload();
        try {
            log = this.payloadTransformers.get(logRequestBean.getContentType()).transform(payload);
        }
        catch (Exception exp) {
            LOGGER.warn(LogApiConstants.LOG_MARKER_WARN, "Failed to unpack payload \n\"{}\"", (Object)payload);
            throw Exceptions.unprocessableEntity("{} couldn't be processed", payload);
        }
        log.setApplicationType(LogApplicationTypeValidator.normalize(logRequestBean.getApplicationType()));
        log.setDimensions(DimensionValidation.normalize(logRequestBean.getDimensions()));
        if (validate) {
            this.validate(log);
        }
        return log;
    }

    public void validate(Log log) {
        LOGGER.trace(LogApiConstants.LOG_MARKER, "Validating log {}", (Object)log);
        try {
            if (log.getApplicationType() != null && !log.getApplicationType().isEmpty()) {
                LogApplicationTypeValidator.validate(log.getApplicationType());
            }
            if (log.getDimensions() != null) {
                DimensionValidation.validate(log.getDimensions(), null);
            }
        }
        catch (Exception exp) {
            LOGGER.warn(LogApiConstants.LOG_MARKER_WARN, "Log {} not valid, error is {}", (Object)log, (Object)exp);
            throw exp;
        }
        LOGGER.debug(LogApiConstants.LOG_MARKER, "Log {} considered valid", (Object)log);
    }

    public void sendToKafka(Log log, String tenantId) {
        String envelope = this.serializer.logEnvelopeToJson(this.newLogEnvelope(log, tenantId));
        this.validateEnvelopeSize(envelope);
        KeyedMessage keyedMessage = new KeyedMessage(this.config.logTopic, (Object)this.buildKey(tenantId, log), (Object)envelope);
        LOGGER.debug(LogApiConstants.LOG_MARKER_KAFKA, "Shipping kafka message {}", (Object)keyedMessage);
        this.producer.send(keyedMessage);
    }

    public void validateContentLength(Integer contentLength) {
        LOGGER.debug("validateContentLength(length=%d)", (Object)contentLength);
        if (contentLength == null) {
            throw Exceptions.lengthRequired("Content length header is missing", "Content length is required to estimate if payload can be processed");
        }
        if (contentLength >= this.config.logSize) {
            throw Exceptions.payloadTooLarge("Log payload size exceeded", String.format("Maximum allowed size is %d bytes", this.config.logSize));
        }
    }

    public void validateContentType(MediaType contentType) {
        if (contentType == null) {
            throw Exceptions.headerMissing("Content-Type");
        }
    }

    public void validateEnvelopeSize(String envelope) {
        int size;
        if (!StringUtils.isEmpty((CharSequence)envelope) && (size = envelope.getBytes(Charset.forName("UTF-8")).length) >= this.config.logSize) {
            throw Exceptions.internalServerError("Envelope size exceeded", String.format("Maximum allowed size is %d bytes", this.config.logSize), null);
        }
    }

    protected LogEnvelope newLogEnvelope(Log log, String tenantId) {
        return new LogEnvelope(log, (Map<String, Object>)new ImmutableMap.Builder().put((Object)"tenantId", (Object)tenantId).put((Object)"region", (Object)this.config.region).build());
    }

    private String buildKey(String tenantId, Log log) {
        StringBuilder key = new StringBuilder();
        key.append(tenantId);
        if (StringUtils.isNotEmpty((CharSequence)log.getApplicationType())) {
            key.append(log.getApplicationType());
        }
        if (MapUtils.isNotEmpty(log.getDimensions())) {
            for (Map.Entry<String, String> dim : this.buildSortedDimSet(log.getDimensions())) {
                key.append(dim.getKey());
                key.append(dim.getValue());
            }
        }
        return key.toString();
    }

    private List<Map.Entry<String, String>> buildSortedDimSet(Map<String, String> dimMap) {
        ArrayList dims = Lists.newArrayList(dimMap.entrySet());
        Collections.sort(dims, DIMENSIONS_COMPARATOR);
        return dims;
    }
}

