/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.app.validation;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import monasca.log.api.resource.exception.Exceptions;

public final class Validation {
    private static final Splitter COMMA_SPLITTER_FOR_LOG = Splitter.on((char)',').trimResults();

    private Validation() {
    }

    public static Map<String, String> parseLogDimensions(String dimensionsStr) {
        Validation.validateNotNullOrEmpty(dimensionsStr, "dimensions");
        HashMap<String, String> dimensions = new HashMap<String, String>();
        for (String dimensionStr : COMMA_SPLITTER_FOR_LOG.split((CharSequence)dimensionsStr)) {
            if (dimensionStr.isEmpty()) {
                throw Exceptions.unprocessableEntity("Dimension cannot be empty", new Object[0]);
            }
            int index = dimensionStr.indexOf(58);
            if (index == -1) {
                throw Exceptions.unprocessableEntity("%s is not a valid dimension", dimensionStr);
            }
            String dimensionKey = dimensionStr.substring(0, index);
            String dimensionValue = dimensionStr.substring(index + 1);
            dimensions.put(dimensionKey, dimensionValue);
        }
        return dimensions;
    }

    public static void validateNotNullOrEmpty(String value, String parameterName) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw Exceptions.unprocessableEntity("%s is required", parameterName);
        }
    }
}

