/*
 * Decompiled with CFR 0.152.
 */
package monasca.log.api.model;

import java.beans.Transient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Log
extends HashMap<String, Object> {
    private static final long serialVersionUID = 685205295808136758L;
    private static final String KEY_DIMENSIONS = "dimensions";
    private static final String KEY_APPLICATION_TYPE = "application_type";
    private static final String KEY_MESSAGE = "message";

    public Log() {
        super(3);
    }

    public Log(String applicationType, Map<String, String> dimensions, String message) {
        this();
        if (StringUtils.isNotEmpty((CharSequence)applicationType)) {
            this.setApplicationType(applicationType);
        }
        if (dimensions != null) {
            this.setDimensions(dimensions);
        }
        if (message != null) {
            this.setMessage(message);
        }
    }

    public Log setDimensions(Map<String, String> dimensions) {
        if (dimensions != null) {
            this.put(KEY_DIMENSIONS, dimensions);
        }
        return this;
    }

    @Transient
    public Map<String, String> getDimensions() {
        return (Map)this.get(KEY_DIMENSIONS);
    }

    public Log setApplicationType(String applicationType) {
        if (StringUtils.isNotEmpty((CharSequence)applicationType)) {
            this.put(KEY_APPLICATION_TYPE, applicationType);
        }
        return this;
    }

    @Transient
    public String getApplicationType() {
        String val = (String)this.get(KEY_APPLICATION_TYPE);
        return val != null ? val : "";
    }

    public Log setMessage(String message) {
        this.put(KEY_MESSAGE, message);
        return this;
    }

    @Transient
    public String getMessage() {
        String val = (String)this.get(KEY_MESSAGE);
        return val != null ? val : "";
    }

    public Log append(String key, String val) {
        this.put(key, val);
        return this;
    }
}

