/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.pipeline.ManagedPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaConsumerRunnableBasic<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerRunnableBasic.class);
    private final KafkaChannel kafkaChannel;
    private final int threadNumber;
    private final ManagedPipeline<T> pipeline;
    private volatile boolean stop = false;

    public KafkaConsumerRunnableBasic(KafkaChannel kafkaChannel, ManagedPipeline<T> pipeline, int threadNumber) {
        this.kafkaChannel = kafkaChannel;
        this.pipeline = pipeline;
        this.threadNumber = threadNumber;
    }

    protected abstract void publishHeartbeat();

    protected abstract void handleMessage(String var1);

    protected void markRead() {
        this.kafkaChannel.markRead();
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public void run() {
        ConsumerIterator it = this.kafkaChannel.getKafkaStream().iterator();
        logger.debug("KafkaChannel {} has stream", (Object)this.threadNumber);
        while (!this.stop) {
            try {
                if (!it.hasNext()) continue;
                String s = new String((byte[])it.next().message());
                logger.debug("Thread {}: {}", (Object)this.threadNumber, (Object)s);
                this.handleMessage(s);
            }
            catch (ConsumerTimeoutException cte) {
                this.publishHeartbeat();
            }
        }
        logger.debug("Shutting down Thread: {}", (Object)this.threadNumber);
        this.kafkaChannel.stop();
    }

    protected void publishEvent(T event) {
        if (this.pipeline.publishEvent(event)) {
            this.markRead();
        }
    }
}

