/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline.event;

import com.codahale.metrics.Counter;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.setup.Environment;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import monasca.common.model.metric.Metric;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.configuration.PipelineConfiguration;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.MetricRepository;
import monasca.persister.repository.Sha1HashId;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricHandler
extends FlushableHandler<MetricEnvelope[]> {
    private static final Logger logger = LoggerFactory.getLogger(MetricHandler.class);
    private static final String TENANT_ID = "tenantId";
    private static final String REGION = "region";
    private final int ordinal;
    private final SimpleDateFormat simpleDateFormat;
    private final MetricRepository verticaMetricRepository;
    private final Counter metricCounter;
    private final Counter definitionCounter;
    private final Counter dimensionCounter;
    private final Counter definitionDimensionsCounter;

    @Inject
    public MetricHandler(MetricRepository metricRepository, @Assisted PipelineConfiguration configuration, Environment environment, @Assisted(value="ordinal") int ordinal, @Assisted(value="batchSize") int batchSize) {
        super(configuration, environment, ordinal, batchSize, MetricHandler.class.getName());
        String handlerName = String.format("%s[%d]", MetricHandler.class.getName(), ordinal);
        this.verticaMetricRepository = metricRepository;
        this.metricCounter = environment.metrics().counter(handlerName + "." + "metrics-added-to-batch-counter");
        this.definitionCounter = environment.metrics().counter(handlerName + "." + "metric-definitions-added-to-batch-counter");
        this.dimensionCounter = environment.metrics().counter(handlerName + "." + "metric-dimensions-added-to-batch-counter");
        this.definitionDimensionsCounter = environment.metrics().counter(handlerName + "." + "metric-definition-dimensions-added-to-batch-counter");
        this.ordinal = ordinal;
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0"));
    }

    @Override
    public int process(MetricEnvelope[] metricEnvelopes) throws Exception {
        int metricCount = 0;
        for (MetricEnvelope metricEnvelope : metricEnvelopes) {
            metricCount += this.processEnvelope(metricEnvelope);
        }
        return metricCount;
    }

    private int processEnvelope(MetricEnvelope metricEnvelope) {
        int metricCount = 0;
        Metric metric = metricEnvelope.metric;
        Map meta = metricEnvelope.meta;
        logger.debug("ordinal: {}", (Object)this.ordinal);
        logger.debug("metric: {}", (Object)metric);
        logger.debug("meta: {}", (Object)meta);
        String tenantId = "";
        if (meta.containsKey(TENANT_ID)) {
            tenantId = (String)meta.get(TENANT_ID);
        } else {
            logger.warn("Failed to find tenantId in message envelope meta data. Metric message may be malformed. Setting tenantId to empty string.");
            logger.warn("metric: {}", (Object)metric.toString());
            logger.warn("meta: {}", (Object)meta.toString());
        }
        String region = "";
        if (meta.containsKey(REGION)) {
            region = (String)meta.get(REGION);
        } else {
            logger.warn("Failed to find region in message envelope meta data. Metric message may be malformed. Setting region to empty string.");
            logger.warn("metric: {}", (Object)metric.toString());
            logger.warn("meta: {}", (Object)meta.toString());
        }
        StringBuilder definitionIdStringToHash = new StringBuilder(this.trunc(metric.getName(), 255));
        definitionIdStringToHash.append(this.trunc(tenantId, 255));
        definitionIdStringToHash.append(this.trunc(region, 255));
        byte[] definitionIdSha1Hash = DigestUtils.sha((String)definitionIdStringToHash.toString());
        Sha1HashId definitionSha1HashId = new Sha1HashId(definitionIdSha1Hash);
        this.verticaMetricRepository.addDefinitionToBatch(definitionSha1HashId, this.trunc(metric.getName(), 255), this.trunc(tenantId, 255), this.trunc(region, 255));
        this.definitionCounter.inc();
        StringBuilder dimensionIdStringToHash = new StringBuilder();
        Map<String, String> preppedDimMap = this.prepDimensions(metric.getDimensions());
        for (Map.Entry<String, String> entry : preppedDimMap.entrySet()) {
            dimensionIdStringToHash.append(entry.getKey());
            dimensionIdStringToHash.append(entry.getValue());
        }
        byte[] dimensionIdSha1Hash = DigestUtils.sha((String)dimensionIdStringToHash.toString());
        Sha1HashId dimensionsSha1HashId = new Sha1HashId(dimensionIdSha1Hash);
        for (Map.Entry<String, String> entry : preppedDimMap.entrySet()) {
            this.verticaMetricRepository.addDimensionToBatch(dimensionsSha1HashId, entry.getKey(), entry.getValue());
            this.dimensionCounter.inc();
        }
        StringBuilder definitionDimensionsIdStringToHash = new StringBuilder(definitionSha1HashId.toHexString());
        definitionDimensionsIdStringToHash.append(dimensionsSha1HashId.toHexString());
        byte[] definitionDimensionsIdSha1Hash = DigestUtils.sha((String)definitionDimensionsIdStringToHash.toString());
        Sha1HashId definitionDimensionsSha1HashId = new Sha1HashId(definitionDimensionsIdSha1Hash);
        this.verticaMetricRepository.addDefinitionDimensionToBatch(definitionDimensionsSha1HashId, definitionSha1HashId, dimensionsSha1HashId);
        this.definitionDimensionsCounter.inc();
        if (metric.getTimeValues() != null) {
            for (double[] timeValuePairs : metric.getTimeValues()) {
                String timeStamp = this.simpleDateFormat.format(new Date((long)(timeValuePairs[0] * 1000.0)));
                double value = timeValuePairs[1];
                this.verticaMetricRepository.addMetricToBatch(definitionDimensionsSha1HashId, timeStamp, value);
                this.metricCounter.inc();
                ++metricCount;
            }
        } else {
            String timeStamp = this.simpleDateFormat.format(new Date(metric.getTimestamp() * 1000L));
            double value = metric.getValue();
            this.verticaMetricRepository.addMetricToBatch(definitionDimensionsSha1HashId, timeStamp, value);
            this.metricCounter.inc();
            ++metricCount;
        }
        return metricCount;
    }

    @Override
    public void flushRepository() {
        this.verticaMetricRepository.flush();
    }

    private Map<String, String> prepDimensions(Map<String, String> dimMap) {
        TreeMap<String, String> newDimMap = new TreeMap<String, String>();
        if (dimMap != null) {
            for (String dimName : dimMap.keySet()) {
                String dimValue;
                if (dimName == null || dimName.isEmpty() || (dimValue = dimMap.get(dimName)) == null || dimValue.isEmpty()) continue;
                newDimMap.put(this.trunc(dimName, 255), this.trunc(dimValue, 255));
            }
        }
        return newDimMap;
    }

    private String trunc(String s, int l) {
        if (s == null) {
            return "";
        }
        if (s.length() <= l) {
            return s;
        }
        String r = s.substring(0, l);
        logger.warn("Input string exceeded max column length. Truncating input string {} to {} chars", (Object)s, (Object)l);
        logger.warn("Resulting string {}", (Object)r);
        return r;
    }
}

