/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Inject;
import io.dropwizard.setup.Environment;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.MonPersisterConfiguration;
import monasca.persister.repository.AlarmRepository;
import monasca.persister.repository.InfluxRepository;
import org.influxdb.dto.Serie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBAlarmRepository
extends InfluxRepository
implements AlarmRepository {
    private static final Logger logger = LoggerFactory.getLogger(InfluxDBAlarmRepository.class);
    private static final String ALARM_STATE_HISTORY_NAME = "alarm_state_history";
    private static final String[] COLUMN_NAMES = new String[]{"tenant_id", "alarm_id", "metrics", "old_state", "new_state", "reason", "reason_data", "time"};
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final Timer flushTimer;
    private List<AlarmStateTransitionedEvent> alarmStateTransitionedEventList = new LinkedList<AlarmStateTransitionedEvent>();
    public final Meter alarmStateHistoryMeter;

    @Inject
    public InfluxDBAlarmRepository(MonPersisterConfiguration configuration, Environment environment) {
        super(configuration, environment);
        this.flushTimer = this.environment.metrics().timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"flush-timer"}));
        this.alarmStateHistoryMeter = this.environment.metrics().meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"alarm_state_history-meter"}));
    }

    @Override
    public void addToBatch(AlarmStateTransitionedEvent alarmStateTransitionedEvent) {
        this.alarmStateTransitionedEventList.add(alarmStateTransitionedEvent);
        this.alarmStateHistoryMeter.mark();
    }

    @Override
    public void flush() {
        try {
            if (this.alarmStateTransitionedEventList.isEmpty()) {
                logger.debug("There are no alarm state transition events to be written to the influxDB");
                logger.debug("Returning from flush");
                return;
            }
            long startTime = System.currentTimeMillis();
            Timer.Context context = this.flushTimer.time();
            Serie.Builder builder = new Serie.Builder(ALARM_STATE_HISTORY_NAME);
            logger.debug("Created serie: {}", (Object)ALARM_STATE_HISTORY_NAME);
            builder.columns(COLUMN_NAMES);
            if (logger.isDebugEnabled()) {
                this.logColumnNames(COLUMN_NAMES);
            }
            for (AlarmStateTransitionedEvent alarmStateTransitionedEvent : this.alarmStateTransitionedEventList) {
                builder.values(new Object[]{alarmStateTransitionedEvent.tenantId, alarmStateTransitionedEvent.alarmId, OBJECT_MAPPER.writeValueAsString((Object)alarmStateTransitionedEvent.metrics), alarmStateTransitionedEvent.oldState, alarmStateTransitionedEvent.newState, alarmStateTransitionedEvent.stateChangeReason, "{}", alarmStateTransitionedEvent.timestamp});
            }
            Serie[] series = new Serie[]{builder.build()};
            if (logger.isDebugEnabled()) {
                this.logColValues(series[0]);
            }
            this.influxDB.write(this.configuration.getInfluxDBConfiguration().getName(), TimeUnit.SECONDS, series);
            context.stop();
            long endTime = System.currentTimeMillis();
            logger.debug("Commiting batch took {} seconds", (Object)((endTime - startTime) / 1000L));
        }
        catch (Exception e) {
            logger.error("Failed to write alarm state history to database", (Throwable)e);
        }
        this.alarmStateTransitionedEventList.clear();
    }

    static {
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }
}

