/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository;

import com.codahale.metrics.Timer;
import io.dropwizard.setup.Environment;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Inject;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.MonPersisterConfiguration;
import monasca.persister.repository.AlarmRepository;
import monasca.persister.repository.VerticaRepository;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticaAlarmRepository
extends VerticaRepository
implements AlarmRepository {
    private static final Logger logger = LoggerFactory.getLogger(VerticaAlarmRepository.class);
    private final Environment environment;
    private static final String SQL_INSERT_INTO_ALARM_HISTORY = "insert into MonAlarms.StateHistory (tenant_id, alarm_id, old_state, new_state, reason, reason_data, time_stamp) values (:tenant_id, :alarm_id, :old_state, :new_state, :reason, :reason_data, :time_stamp)";
    private PreparedBatch batch;
    private final Timer commitTimer;
    private final SimpleDateFormat simpleDateFormat;

    @Inject
    public VerticaAlarmRepository(DBI dbi, MonPersisterConfiguration configuration, Environment environment) throws NoSuchAlgorithmException, SQLException {
        super(dbi);
        logger.debug("Instantiating: " + this);
        this.environment = environment;
        this.commitTimer = this.environment.metrics().timer(this.getClass().getName() + "." + "commits-timer");
        this.handle.getConnection().setAutoCommit(false);
        this.batch = this.handle.prepareBatch(SQL_INSERT_INTO_ALARM_HISTORY);
        this.handle.begin();
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT-0"));
    }

    @Override
    public void addToBatch(AlarmStateTransitionedEvent message) {
        String timeStamp = this.simpleDateFormat.format(new Date(message.timestamp * 1000L));
        ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)this.batch.add().bind(0, message.tenantId)).bind(1, message.alarmId)).bind(2, message.oldState.name())).bind(3, message.newState.name())).bind(4, message.stateChangeReason)).bind(5, "{}")).bind(6, timeStamp);
    }

    @Override
    public void flush() {
        try {
            this.commitBatch();
        }
        catch (Exception e) {
            logger.error("Failed to write alarms to database", (Throwable)e);
            if (this.handle.isInTransaction()) {
                this.handle.rollback();
            }
            this.handle.begin();
        }
    }

    private void commitBatch() {
        long startTime = System.currentTimeMillis();
        Timer.Context context = this.commitTimer.time();
        this.batch.execute();
        this.handle.commit();
        this.handle.begin();
        context.stop();
        long endTime = System.currentTimeMillis();
        logger.debug("Commiting batch took " + (endTime - startTime) / 1000L + " seconds");
    }
}

