/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import monasca.persister.consumer.KafkaConsumerRunnableBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer<T> {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumer.class);
    private static final int WAIT_TIME = 10;
    private ExecutorService executorService;
    private final KafkaConsumerRunnableBasic<T> kafkaConsumerRunnableBasic;
    private final String threadId;

    @Inject
    public KafkaConsumer(@Assisted KafkaConsumerRunnableBasic<T> kafkaConsumerRunnableBasic, @Assisted String threadId) {
        this.kafkaConsumerRunnableBasic = kafkaConsumerRunnableBasic;
        this.threadId = threadId;
    }

    public void start() {
        logger.info("[{}]: start", (Object)this.threadId);
        this.executorService = Executors.newFixedThreadPool(1);
        this.executorService.submit(this.kafkaConsumerRunnableBasic);
    }

    public void stop() {
        logger.info("[{}]: stop", (Object)this.threadId);
        this.kafkaConsumerRunnableBasic.stop();
        if (this.executorService != null) {
            logger.info("[{}]: shutting down executor service", (Object)this.threadId);
            this.executorService.shutdown();
            try {
                logger.info("[{}]: awaiting termination...", (Object)this.threadId);
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    logger.warn("[{}]: did not shut down in {} seconds", (Object)this.threadId, (Object)10);
                }
                logger.info("[{}]: terminated", (Object)this.threadId);
            }
            catch (InterruptedException e) {
                logger.info("[{}]: awaitTermination interrupted", (Object)this.threadId, (Object)e);
            }
        }
    }
}

