/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import monasca.persister.consumer.KafkaChannel;
import monasca.persister.pipeline.ManagedPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerRunnableBasic<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerRunnableBasic.class);
    private final KafkaChannel kafkaChannel;
    private final String threadId;
    private final ManagedPipeline<T> pipeline;
    private volatile boolean stop = false;

    @Inject
    public KafkaConsumerRunnableBasic(@Assisted KafkaChannel kafkaChannel, @Assisted ManagedPipeline<T> pipeline, @Assisted String threadId) {
        this.kafkaChannel = kafkaChannel;
        this.pipeline = pipeline;
        this.threadId = threadId;
    }

    protected void publishHeartbeat() {
        this.publishEvent(null);
    }

    private void markRead() {
        logger.debug("[{}]: marking read", (Object)this.threadId);
        this.kafkaChannel.markRead();
    }

    public void stop() {
        logger.info("[{}]: stop", (Object)this.threadId);
        this.stop = true;
        if (this.pipeline.shutdown()) {
            this.markRead();
        }
    }

    @Override
    public void run() {
        logger.info("[{}]: run", (Object)this.threadId);
        ConsumerIterator it = this.kafkaChannel.getKafkaStream().iterator();
        logger.debug("[{}]: KafkaChannel has stream iterator", (Object)this.threadId);
        while (!this.stop) {
            try {
                if (!it.hasNext()) continue;
                String msg = new String((byte[])it.next().message());
                logger.debug("[{}]: {}", (Object)this.threadId, (Object)msg);
                this.publishEvent(msg);
            }
            catch (ConsumerTimeoutException cte) {
                this.publishHeartbeat();
            }
        }
        logger.info("[{}]: shutting down", (Object)this.threadId);
        this.kafkaChannel.stop();
    }

    protected void publishEvent(String msg) {
        if (this.pipeline.publishEvent(msg)) {
            this.markRead();
        }
    }
}

