/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.dbi;

import com.google.inject.ProvisionException;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.inject.Provider;
import monasca.persister.configuration.PersisterConfig;
import org.skife.jdbi.v2.DBI;

public class DBIProvider
implements Provider<DBI> {
    private final Environment environment;
    private final PersisterConfig configuration;

    @Inject
    public DBIProvider(Environment environment, PersisterConfig configuration) {
        this.environment = environment;
        this.configuration = configuration;
    }

    public DBI get() {
        try {
            return new DBIFactory().build(this.environment, this.configuration.getDataSourceFactory(), "vertica");
        }
        catch (ClassNotFoundException e) {
            throw new ProvisionException("Failed to provision DBI", (Throwable)e);
        }
    }
}

