/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.pipeline.event;

import com.codahale.metrics.Counter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.configuration.PipelineConfig;
import monasca.persister.pipeline.event.FlushableHandler;
import monasca.persister.repository.Repo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStateTransitionedEventHandler
extends FlushableHandler<AlarmStateTransitionedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AlarmStateTransitionedEventHandler.class);
    private final Repo<AlarmStateTransitionedEvent> alarmRepo;
    private final Counter alarmStateTransitionCounter;

    @Inject
    public AlarmStateTransitionedEventHandler(Repo<AlarmStateTransitionedEvent> alarmRepo, Environment environment, @Assisted PipelineConfig configuration, @Assisted(value="threadId") String threadId, @Assisted(value="batchSize") int batchSize) {
        super(configuration, environment, threadId, batchSize);
        this.alarmRepo = alarmRepo;
        this.alarmStateTransitionCounter = environment.metrics().counter(this.handlerName + "." + "alarm-state-transitions-added-to-batch-counter");
    }

    @Override
    protected int process(String msg) throws IOException {
        AlarmStateTransitionedEvent alarmStateTransitionedEvent = (AlarmStateTransitionedEvent)this.objectMapper.readValue(msg, AlarmStateTransitionedEvent.class);
        logger.debug("[{}]: [{}:{}] {}", new Object[]{this.threadId, this.getBatchCount(), this.getMsgCount(), alarmStateTransitionedEvent});
        this.alarmRepo.addToBatch(alarmStateTransitionedEvent);
        this.alarmStateTransitionCounter.inc();
        return 1;
    }

    @Override
    protected void initObjectMapper() {
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.enable(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    @Override
    protected int flushRepository() throws Exception {
        return this.alarmRepo.flush(this.threadId);
    }
}

