/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Inject;
import io.dropwizard.setup.Environment;
import java.util.HashMap;
import java.util.LinkedList;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.repository.influxdb.InfluxAlarmRepo;
import monasca.persister.repository.influxdb.InfluxPoint;
import monasca.persister.repository.influxdb.InfluxV9RepoWriter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class InfluxV9AlarmRepo
extends InfluxAlarmRepo {
    private final InfluxV9RepoWriter influxV9RepoWriter;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DateTimeFormatter dateFormatter = ISODateTimeFormat.dateTime();

    @Inject
    public InfluxV9AlarmRepo(Environment env, InfluxV9RepoWriter influxV9RepoWriter) {
        super(env);
        this.influxV9RepoWriter = influxV9RepoWriter;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    @Override
    protected int write(String id) throws Exception {
        return this.influxV9RepoWriter.write(this.getInfluxPointArry(), id);
    }

    private InfluxPoint[] getInfluxPointArry() throws Exception {
        LinkedList<InfluxPoint> influxPointList = new LinkedList<InfluxPoint>();
        for (AlarmStateTransitionedEvent event : this.alarmStateTransitionedEventList) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("tenant_id", event.tenantId);
            valueMap.put("alarm_id", event.alarmId);
            valueMap.put("metrics", this.objectMapper.writeValueAsString((Object)event.metrics));
            valueMap.put("old_state", event.oldState);
            valueMap.put("new_state", event.newState);
            valueMap.put("sub_alarms", this.objectMapper.writeValueAsString((Object)event.subAlarms));
            valueMap.put("reason", event.stateChangeReason);
            valueMap.put("reason_data", "{}");
            DateTime dateTime = new DateTime(event.timestamp, DateTimeZone.UTC);
            String dateString = this.dateFormatter.print((ReadableInstant)dateTime);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant_id", event.tenantId);
            tags.put("alarm_id", event.alarmId);
            InfluxPoint influxPoint = new InfluxPoint("alarm_state_history", tags, dateString, valueMap);
            influxPointList.add(influxPoint);
        }
        return influxPointList.toArray(new InfluxPoint[influxPointList.size()]);
    }
}

