/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import io.dropwizard.setup.Environment;
import java.util.Map;
import monasca.common.model.metric.Metric;
import monasca.common.model.metric.MetricEnvelope;
import monasca.persister.repository.influxdb.Definition;
import monasca.persister.repository.influxdb.Dimensions;
import monasca.persister.repository.influxdb.InfluxRepo;
import monasca.persister.repository.influxdb.Measurement;
import monasca.persister.repository.influxdb.MeasurementBuffer;

public abstract class InfluxMetricRepo
extends InfluxRepo<MetricEnvelope> {
    protected final MeasurementBuffer measurementBuffer = new MeasurementBuffer();

    public InfluxMetricRepo(Environment env) {
        super(env);
    }

    @Override
    public void addToBatch(MetricEnvelope metricEnvelope, String id) {
        Metric metric = metricEnvelope.metric;
        Map meta = metricEnvelope.meta;
        Definition definition = new Definition(metric.getName(), (String)meta.get("tenantId"), (String)meta.get("region"));
        Dimensions dimensions = new Dimensions(metric.getDimensions());
        Measurement measurement = new Measurement(metric.getTimestamp(), metric.getValue(), metric.getValueMeta());
        this.measurementBuffer.put(definition, dimensions, measurement);
    }

    @Override
    protected void clearBuffers() {
        this.measurementBuffer.clear();
    }

    @Override
    protected boolean isBufferEmpty() {
        return this.measurementBuffer.isEmpty();
    }
}

