/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Inject;
import io.dropwizard.setup.Environment;
import java.util.HashMap;
import java.util.LinkedList;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.persister.repository.RepoException;
import monasca.persister.repository.influxdb.InfluxAlarmRepo;
import monasca.persister.repository.influxdb.InfluxPoint;
import monasca.persister.repository.influxdb.InfluxV9RepoWriter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9AlarmRepo
extends InfluxAlarmRepo {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9AlarmRepo.class);
    private final InfluxV9RepoWriter influxV9RepoWriter;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DateTimeFormatter dateFormatter = ISODateTimeFormat.dateTime();

    @Inject
    public InfluxV9AlarmRepo(Environment env, InfluxV9RepoWriter influxV9RepoWriter) {
        super(env);
        this.influxV9RepoWriter = influxV9RepoWriter;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    @Override
    protected int write(String id) throws RepoException {
        return this.influxV9RepoWriter.write(this.getInfluxPointArry(id), id);
    }

    private InfluxPoint[] getInfluxPointArry(String id) {
        LinkedList<InfluxPoint> influxPointList = new LinkedList<InfluxPoint>();
        for (AlarmStateTransitionedEvent event : this.alarmStateTransitionedEventList) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            if (event.tenantId == null) {
                logger.error("[{}]: tenant id cannot be null. Dropping alarm state history event.", (Object)id);
                continue;
            }
            valueMap.put("tenant_id", event.tenantId);
            if (event.alarmId == null) {
                logger.error("[{}]: alarm id cannot be null. Dropping alarm state history event.", (Object)id);
                continue;
            }
            valueMap.put("alarm_id", event.alarmId);
            if (event.metrics == null) {
                logger.error("[{}]: metrics cannot be null. Settings metrics to empty JSON", (Object)id);
                valueMap.put("metrics", "{}");
            } else {
                try {
                    valueMap.put("metrics", this.objectMapper.writeValueAsString((Object)event.metrics));
                }
                catch (JsonProcessingException e) {
                    logger.error("[{}]: failed to serialize metrics {}", new Object[]{id, event.metrics, e});
                    logger.error("[{}]: setting metrics to empty JSON", (Object)id);
                    valueMap.put("metrics", "{}");
                }
            }
            if (event.oldState == null) {
                logger.error("[{}]: old state cannot be null. Setting old state to empty string.", (Object)id);
                valueMap.put("old_state", "");
            } else {
                valueMap.put("old_state", event.oldState);
            }
            if (event.newState == null) {
                logger.error("[{}]: new state cannot be null. Setting new state to empty string.", (Object)id);
                valueMap.put("new_state", "");
            } else {
                valueMap.put("new_state", event.newState);
            }
            if (event.link == null) {
                valueMap.put("link", "");
            } else {
                valueMap.put("link", event.link);
            }
            if (event.lifecycleState == null) {
                valueMap.put("lifecycle_state", "");
            } else {
                valueMap.put("lifecycle_state", event.lifecycleState);
            }
            if (event.subAlarms == null) {
                logger.debug("[{}]: sub alarms is null. Setting sub alarms to empty JSON", (Object)id);
                valueMap.put("sub_alarms", "[]");
            } else {
                try {
                    valueMap.put("sub_alarms", this.objectMapper.writeValueAsString((Object)event.subAlarms));
                }
                catch (JsonProcessingException e) {
                    logger.error("[{}]: failed to serialize sub alarms {}", new Object[]{id, event.subAlarms, e});
                    logger.error("[{}]: Setting sub_alarms to empty JSON", (Object)id);
                    valueMap.put("sub_alarms", "[]");
                }
            }
            if (event.stateChangeReason == null) {
                logger.error("[{}]: reason cannot be null. Setting reason to empty string.", (Object)id);
                valueMap.put("reason", "");
            } else {
                valueMap.put("reason", event.stateChangeReason);
            }
            valueMap.put("reason_data", "{}");
            DateTime dateTime = new DateTime(event.timestamp, DateTimeZone.UTC);
            String dateString = this.dateFormatter.print((ReadableInstant)dateTime);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant_id", event.tenantId);
            tags.put("alarm_id", event.alarmId);
            InfluxPoint influxPoint = new InfluxPoint("alarm_state_history", tags, dateString, valueMap);
            influxPointList.add(influxPoint);
        }
        return influxPointList.toArray(new InfluxPoint[influxPointList.size()]);
    }
}

