/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import monasca.persister.configuration.PersisterConfig;
import monasca.persister.repository.RepoException;
import monasca.persister.repository.influxdb.InfluxPoint;
import monasca.persister.repository.influxdb.InfluxWrite;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9RepoWriter {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9RepoWriter.class);
    private final String influxName;
    private final String influxUrl;
    private final String influxCreds;
    private final String influxUser;
    private final String influxPass;
    private final String influxRetentionPolicy;
    private final boolean gzip;
    private final CloseableHttpClient httpClient;
    private final String baseAuthHeader;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public InfluxV9RepoWriter(PersisterConfig config) {
        this.influxName = config.getInfluxDBConfiguration().getName();
        this.influxUrl = config.getInfluxDBConfiguration().getUrl() + "/write";
        this.influxUser = config.getInfluxDBConfiguration().getUser();
        this.influxPass = config.getInfluxDBConfiguration().getPassword();
        this.influxCreds = this.influxUser + ":" + this.influxPass;
        this.influxRetentionPolicy = config.getInfluxDBConfiguration().getRetentionPolicy();
        this.gzip = config.getInfluxDBConfiguration().getGzip();
        this.baseAuthHeader = "Basic " + new String(Base64.encodeBase64((byte[])this.influxCreds.getBytes()));
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(config.getInfluxDBConfiguration().getMaxHttpConnections());
        this.httpClient = this.gzip ? HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).addInterceptorFirst(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
            }
        }).addInterceptorFirst(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs = ceheader.getElements();
                    for (int i = 0; i < codecs.length; ++i) {
                        if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        }).build() : HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write(InfluxPoint[] influxPointArry, String id) throws RepoException {
        HttpPost request = new HttpPost(this.influxUrl);
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Authorization", this.baseAuthHeader);
        InfluxWrite influxWrite = new InfluxWrite(this.influxName, this.influxRetentionPolicy, influxPointArry, new HashMap<String, String>());
        String jsonBody = this.getJsonBody(influxWrite);
        if (this.gzip) {
            logger.debug("[{}]: gzip set to true. sending gzip msg", (Object)id);
            HttpEntity requestEntity = EntityBuilder.create().setText(jsonBody).setContentType(ContentType.APPLICATION_JSON).setContentEncoding("UTF-8").gzipCompress().build();
            request.setEntity(requestEntity);
            request.addHeader("Content-Encoding", "gzip");
        } else {
            logger.debug("[{}]: gzip set to false. sending non-gzip msg", (Object)id);
            StringEntity stringEntity = new StringEntity(jsonBody, "UTF-8");
            request.setEntity((HttpEntity)stringEntity);
        }
        try {
            logger.debug("[{}]: sending {} points to influxdb {} at {}", new Object[]{id, influxPointArry.length, this.influxName, this.influxUrl});
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)request);
            }
            catch (IOException e) {
                throw new RepoException("failed to execute http request", e);
            }
            int rc = response.getStatusLine().getStatusCode();
            if (rc != 200 && rc != 204) {
                logger.error("[{}]: failed to send data to influxdb {} at {}: {}", new Object[]{id, this.influxName, this.influxUrl, String.valueOf(rc)});
                HttpEntity responseEntity = response.getEntity();
                String responseString = null;
                try {
                    responseString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new RepoException("failed to read http response for non ok return code " + rc, e);
                }
                logger.error("[{}]: http response: {}", (Object)id, (Object)responseString);
                throw new RepoException("failed to execute http request to influxdb " + rc + " - " + responseString);
            }
            logger.debug("[{}]: successfully sent {} points to influxdb {} at {}", new Object[]{id, influxPointArry.length, this.influxName, this.influxUrl});
            int n = influxPointArry.length;
            return n;
        }
        finally {
            request.releaseConnection();
        }
    }

    private String getJsonBody(InfluxWrite influxWrite) throws RepoException {
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString((Object)influxWrite);
        }
        catch (JsonProcessingException e) {
            throw new RepoException("failed to serialize json", e);
        }
        return json;
    }
}

