/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import monasca.persister.repository.influxdb.Definition;
import monasca.persister.repository.influxdb.Dimensions;
import monasca.persister.repository.influxdb.Measurement;

public class MeasurementBuffer {
    private final Map<Definition, Map<Dimensions, List<Measurement>>> measurementMap = new HashMap<Definition, Map<Dimensions, List<Measurement>>>();

    public void put(Definition definition, Dimensions dimensions, Measurement measurement) {
        List<Measurement> measurementList;
        Map<Dimensions, List<Measurement>> dimensionsMap = this.measurementMap.get(definition);
        if (dimensionsMap == null) {
            dimensionsMap = this.initDimensionsMap(definition, dimensions);
        }
        if ((measurementList = dimensionsMap.get(dimensions)) == null) {
            measurementList = this.initMeasurementList(dimensionsMap, dimensions);
        }
        measurementList.add(measurement);
    }

    public Set<Map.Entry<Definition, Map<Dimensions, List<Measurement>>>> entrySet() {
        return this.measurementMap.entrySet();
    }

    public void clear() {
        this.measurementMap.clear();
    }

    public boolean isEmpty() {
        return this.measurementMap.isEmpty();
    }

    private Map<Dimensions, List<Measurement>> initDimensionsMap(Definition definition, Dimensions dimensions) {
        HashMap<Dimensions, List<Measurement>> dimensionsMap = new HashMap<Dimensions, List<Measurement>>();
        LinkedList measurementList = new LinkedList();
        dimensionsMap.put(dimensions, measurementList);
        this.measurementMap.put(definition, dimensionsMap);
        return dimensionsMap;
    }

    private List<Measurement> initMeasurementList(Map<Dimensions, List<Measurement>> dimensionsMap, Dimensions dimensions) {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        dimensionsMap.put(dimensions, measurementList);
        return measurementList;
    }
}

