/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.consumer;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.lifecycle.Managed;
import monasca.persister.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConsumer<T>
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger(ManagedConsumer.class);
    private final KafkaConsumer<T> consumer;
    private final String threadId;

    @Inject
    public ManagedConsumer(@Assisted KafkaConsumer<T> kafkaConsumer, @Assisted String threadId) {
        this.consumer = kafkaConsumer;
        this.threadId = threadId;
    }

    public void start() throws Exception {
        logger.debug("[{}]: start", (Object)this.threadId);
        this.consumer.start();
    }

    public void stop() throws Exception {
        logger.debug("[{}]: stop", (Object)this.threadId);
        this.consumer.stop();
    }
}

