/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Measurement {
    private static final Logger logger = LoggerFactory.getLogger(Measurement.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    public final long time;
    public final double value;
    public final Map<String, String> valueMeta;

    public Measurement(long time, double value, @Nullable Map<String, String> valueMeta) {
        this.time = time;
        this.value = value;
        this.valueMeta = valueMeta == null ? new HashMap() : valueMeta;
    }

    public String getISOFormattedTimeString() {
        DateTimeFormatter dateFormatter = ISODateTimeFormat.dateTime();
        Date date = new Date(this.time);
        DateTime dateTime = new DateTime(date.getTime(), DateTimeZone.UTC);
        return dateFormatter.print((ReadableInstant)dateTime);
    }

    public long getTime() {
        return this.time;
    }

    public double getValue() {
        return this.value;
    }

    public Map<String, String> getValueMeta() {
        return this.valueMeta;
    }

    public String getValueMetaJSONString() {
        if (!this.valueMeta.isEmpty()) {
            try {
                return this.objectMapper.writeValueAsString(this.valueMeta);
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to serialize value meta {}", this.valueMeta, (Object)e);
            }
        }
        return null;
    }
}

