/*
 * Decompiled with CFR 0.152.
 */
package monasca.persister.repository.influxdb;

import com.google.inject.Inject;
import io.dropwizard.setup.Environment;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import monasca.persister.repository.RepoException;
import monasca.persister.repository.influxdb.Definition;
import monasca.persister.repository.influxdb.Dimensions;
import monasca.persister.repository.influxdb.InfluxMetricRepo;
import monasca.persister.repository.influxdb.InfluxPoint;
import monasca.persister.repository.influxdb.InfluxV9RepoWriter;
import monasca.persister.repository.influxdb.Measurement;

public class InfluxV9MetricRepo
extends InfluxMetricRepo {
    private final InfluxV9RepoWriter influxV9RepoWriter;

    @Inject
    public InfluxV9MetricRepo(Environment env, InfluxV9RepoWriter influxV9RepoWriter) {
        super(env);
        this.influxV9RepoWriter = influxV9RepoWriter;
    }

    @Override
    protected int write(String id) throws RepoException {
        return this.influxV9RepoWriter.write(this.getInfluxPointArry(), id);
    }

    private InfluxPoint[] getInfluxPointArry() {
        LinkedList<InfluxPoint> influxPointList = new LinkedList<InfluxPoint>();
        for (Map.Entry<Definition, Map<Dimensions, List<Measurement>>> definitionMapEntry : this.measurementBuffer.entrySet()) {
            Definition definition = definitionMapEntry.getKey();
            Map<Dimensions, List<Measurement>> dimensionsMap = definitionMapEntry.getValue();
            for (Map.Entry<Dimensions, List<Measurement>> dimensionsMapEntry : dimensionsMap.entrySet()) {
                Dimensions dimensions = dimensionsMapEntry.getKey();
                List<Measurement> measurementList = dimensionsMapEntry.getValue();
                Map<String, String> tagMap = this.buildTagMap(definition, dimensions);
                for (Measurement measurement : measurementList) {
                    InfluxPoint influxPoint = new InfluxPoint(definition.getName(), tagMap, measurement.getISOFormattedTimeString(), this.buildValueMap(measurement));
                    influxPointList.add(influxPoint);
                }
            }
        }
        return influxPointList.toArray(new InfluxPoint[influxPointList.size()]);
    }

    private Map<String, Object> buildValueMap(Measurement measurement) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("value", measurement.getValue());
        String valueMetaJSONString = measurement.getValueMetaJSONString();
        if (valueMetaJSONString == null || valueMetaJSONString.isEmpty()) {
            valueMap.put("value_meta", "{}");
        } else {
            valueMap.put("value_meta", valueMetaJSONString);
        }
        return valueMap;
    }

    private Map<String, String> buildTagMap(Definition definition, Dimensions dimensions) {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        for (Map.Entry<String, String> dimensionsEntry : dimensions.entrySet()) {
            String name = dimensionsEntry.getKey();
            String value = dimensionsEntry.getValue();
            tagMap.put(name, value);
        }
        tagMap.put("_tenant_id", definition.getTenantId());
        tagMap.put("_region", definition.getRegion());
        return tagMap;
    }
}

