/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.inject.Module;
import java.io.File;
import java.util.Map;
import monasca.common.util.Injector;
import monasca.common.util.config.ConfigurationFactory;
import monasca.thresh.ThresholdingConfiguration;
import monasca.thresh.TopologyModule;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdingEngine {
    private static final Logger logger = LoggerFactory.getLogger(ThresholdingEngine.class);
    private final ThresholdingConfiguration threshConfig;
    private final String topologyName;
    private final boolean local;

    public ThresholdingEngine(ThresholdingConfiguration threshConfig, String topologyName, boolean local) {
        this.threshConfig = threshConfig;
        this.topologyName = topologyName;
        this.local = local;
        logger.info("local set to {}", (Object)local);
    }

    public static final ThresholdingConfiguration configFor(String configFileName) throws Exception {
        return (ThresholdingConfiguration)ConfigurationFactory.forClass(ThresholdingConfiguration.class).build(new File(configFileName));
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 1 && args[0].toLowerCase().contains("version")) {
            ThresholdingEngine.showVersion();
            System.exit(0);
        }
        StatusPrinter.print((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        ThresholdingEngine.showVersion();
        if (args.length < 2) {
            logger.error("Expected configuration file name and topology name arguments");
            System.exit(1);
        }
        logger.info("Instantiating ThresholdingEngine with config file: {}, topology: {}", (Object)args[0], (Object)args[1]);
        ThresholdingEngine engine = new ThresholdingEngine(ThresholdingEngine.configFor(args[0]), args[1], args.length > 2);
        engine.configure();
        engine.run();
    }

    private static void showVersion() {
        Package pkg = Package.getPackage("monasca.thresh");
        logger.info("-------- Version Information --------");
        logger.info("{}", (Object)pkg.getImplementationVersion());
    }

    protected void configure() {
        Injector.registerModules((Module[])new Module[]{new TopologyModule(this.threshConfig)});
    }

    protected void run() throws Exception {
        Config config = (Config)Injector.getInstance(Config.class);
        StormTopology topology = (StormTopology)Injector.getInstance(StormTopology.class);
        config.registerSerialization(SubAlarm.class);
        config.registerSerialization(SubExpression.class);
        if (this.local) {
            logger.info("submitting topology {} to local storm cluster", (Object)this.topologyName);
            new LocalCluster().submitTopology(this.topologyName, (Map)config, topology);
        } else {
            logger.info("submitting topology {} to non-local storm cluster", (Object)this.topologyName);
            StormSubmitter.submitTopology((String)this.topologyName, (Map)config, (StormTopology)topology);
        }
    }
}

