/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.AlarmDefinition;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.service.AlarmDefinitionDAO;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class AlarmDefinitionDAOImpl
implements AlarmDefinitionDAO {
    private static final String SUB_ALARM_SQL = "select sad.*, sadd.* from sub_alarm_definition sad left outer join sub_alarm_definition_dimension sadd on sadd.sub_alarm_definition_id=sad.id where sad.alarm_definition_id = :alarmDefId order by sad.id";
    private final DBI db;

    @Inject
    public AlarmDefinitionDAOImpl(DBI db) {
        this.db = db;
    }

    @Override
    public List<AlarmDefinition> listAll() {
        try (Handle h = this.db.open();){
            String sql = "select * from alarm_definition where deleted_at is NULL order by created_at";
            Query q = h.createQuery("select * from alarm_definition where deleted_at is NULL order by created_at").map((ResultSetMapper)new AlarmDefinitionMapper());
            List alarmDefs = q.list();
            for (AlarmDefinition alarmDef : alarmDefs) {
                alarmDef.setSubExpressions(this.findSubExpressions(h, alarmDef.getId()));
            }
            List list = alarmDefs;
            return list;
        }
    }

    private List<SubExpression> findSubExpressions(Handle h, String alarmDefId) {
        List rows = ((Query)h.createQuery(SUB_ALARM_SQL).bind("alarmDefId", alarmDefId)).list();
        ArrayList<SubExpression> subExpressions = new ArrayList<SubExpression>(rows.size());
        int index = 0;
        while (index < rows.size()) {
            Map row = (Map)rows.get(index);
            String id = (String)row.get("id");
            AggregateFunction function = AggregateFunction.fromJson((String)((String)row.get("function")));
            String metricName = (String)row.get("metric_name");
            AlarmOperator operator = AlarmOperator.fromJson((String)((String)row.get("operator")));
            Double threshold = (Double)row.get("threshold");
            Integer period = (Integer)row.get("period");
            Integer periods = (Integer)row.get("periods");
            HashMap<String, String> dimensions = new HashMap<String, String>();
            while (this.addedDimension(dimensions, id, rows, index)) {
                ++index;
            }
            subExpressions.add(new SubExpression(id, new AlarmSubExpression(function, new MetricDefinition(metricName, dimensions), operator, threshold.doubleValue(), period.intValue(), periods.intValue())));
        }
        return subExpressions;
    }

    private boolean addedDimension(Map<String, String> dimensions, String id, List<Map<String, Object>> rows, int index) {
        if (index >= rows.size()) {
            return false;
        }
        Map<String, Object> row = rows.get(index);
        if (!row.get("id").equals(id)) {
            return false;
        }
        String name = (String)row.get("dimension_name");
        String value = (String)row.get("value");
        if (name != null && !name.isEmpty()) {
            dimensions.put(name, value);
        }
        return true;
    }

    @Override
    public AlarmDefinition findById(String id) {
        try (Handle h = this.db.open();){
            AlarmDefinition alarmDefinition = (AlarmDefinition)((Object)((Query)h.createQuery("select * from alarm_definition where id = :id and deleted_at is NULL").bind("id", id)).map((ResultSetMapper)new AlarmDefinitionMapper()).first());
            if (alarmDefinition != null) {
                alarmDefinition.setSubExpressions(this.findSubExpressions(h, alarmDefinition.getId()));
            }
            AlarmDefinition alarmDefinition2 = alarmDefinition;
            return alarmDefinition2;
        }
    }

    private static class AlarmDefinitionMapper
    implements ResultSetMapper<AlarmDefinition> {
        private AlarmDefinitionMapper() {
        }

        public AlarmDefinition map(int rowIndex, ResultSet rs, StatementContext ctxt) throws SQLException {
            String matchByString = rs.getString("match_by");
            ArrayList<Object> matchBy = matchByString == null || matchByString.isEmpty() ? new ArrayList(0) : new ArrayList<String>(Arrays.asList(matchByString.split(",")));
            AlarmDefinition real = new AlarmDefinition(rs.getString("id"), rs.getString("tenant_id"), rs.getString("name"), rs.getString("description"), new AlarmExpression(rs.getString("expression")), rs.getString("severity"), rs.getBoolean("actions_enabled"), null, matchBy);
            return real;
        }
    }
}

