/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.List;
import monasca.common.model.metric.MetricEnvelope;
import monasca.common.model.metric.MetricEnvelopes;
import monasca.thresh.MetricSpoutConfig;
import monasca.thresh.domain.model.TenantIdAndMetricName;
import monasca.thresh.infrastructure.thresholding.KafkaSpout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSpout
extends KafkaSpout {
    private static final Logger logger = LoggerFactory.getLogger(MetricSpout.class);
    private static final long serialVersionUID = 744004533863562119L;
    public static final String[] FIELDS = new String[]{"tenantIdAndMetricName", "apiTimeStamp", "metric"};
    public static final String DEFAULT_TENANT_ID = "TENANT_ID_NOT_SET";

    public MetricSpout(MetricSpoutConfig metricSpoutConfig) {
        super(metricSpoutConfig);
        logger.info("Created");
    }

    @Override
    protected void processMessage(byte[] message, SpoutOutputCollector collector) {
        MetricEnvelope metricEnvelope;
        try {
            metricEnvelope = MetricEnvelopes.fromJson((byte[])message);
            logger.debug("metric envelope: {}", (Object)metricEnvelope);
        }
        catch (RuntimeException re) {
            logger.warn("Error parsing MetricEnvelope", (Throwable)re);
            return;
        }
        String tenantId = (String)metricEnvelope.meta.get("tenantId");
        if (tenantId == null) {
            logger.error("No tenantId so using default tenantId {} for Metric {}", (Object)DEFAULT_TENANT_ID, (Object)metricEnvelope.metric);
            tenantId = DEFAULT_TENANT_ID;
        }
        collector.emit((List)new Values(new Object[]{new TenantIdAndMetricName(tenantId, metricEnvelope.metric.definition().name), metricEnvelope.creationTime, metricEnvelope.metric}));
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(FIELDS));
    }
}

