/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.domain.model;

import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.util.stats.SlidingWindowStats;
import monasca.common.util.time.TimeResolution;
import monasca.thresh.domain.model.SubAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubAlarmStats {
    private static final Logger logger = LoggerFactory.getLogger(SubAlarmStats.class);
    private static final int FUTURE_SLOTS = 2;
    private static final int UNDETERMINED_COEFFICIENT = 2;
    private final int slotWidth;
    private SubAlarm subAlarm;
    private SlidingWindowStats stats;
    protected int emptyWindowObservationThreshold;
    private int emptyWindowObservations;

    public SubAlarmStats(SubAlarm subAlarm, long viewEndTimestamp) {
        this(subAlarm, TimeResolution.MINUTES, viewEndTimestamp);
    }

    public SubAlarmStats(SubAlarm subAlarm, TimeResolution timeResolution, long viewEndTimestamp) {
        this.slotWidth = subAlarm.getExpression().getPeriod();
        this.subAlarm = subAlarm;
        this.subAlarm.setNoState(true);
        this.initialize(subAlarm, timeResolution, viewEndTimestamp);
    }

    private void initialize(SubAlarm subAlarm, TimeResolution timeResolution, long viewEndTimestamp) {
        this.stats = new SlidingWindowStats(subAlarm.getExpression().getFunction().toStatistic(), timeResolution, (long)this.slotWidth, subAlarm.getExpression().getPeriods(), 2, viewEndTimestamp);
        int period = subAlarm.getExpression().getPeriod();
        int periodMinutes = period < 60 ? 1 : period / 60;
        this.emptyWindowObservationThreshold = periodMinutes * subAlarm.getExpression().getPeriods() * 2;
        this.emptyWindowObservations = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluateAndSlideWindow(long slideToTimestamp, long alarmDelay) {
        try {
            boolean bl = this.evaluate(slideToTimestamp, alarmDelay);
            return bl;
        }
        catch (Exception e) {
            logger.error("Failed to evaluate {}", (Object)this, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.slideWindow(slideToTimestamp, alarmDelay);
        }
    }

    public void slideWindow(long slideToTimestamp, long alarmDelay) {
        this.stats.slideViewTo(slideToTimestamp, alarmDelay);
    }

    public SlidingWindowStats getStats() {
        return this.stats;
    }

    public SubAlarm getSubAlarm() {
        return this.subAlarm;
    }

    public String toString() {
        return String.format("SubAlarmStats [subAlarm=%s, stats=%s, emptyWindowObservations=%s, emptyWindowObservationThreshold=%s]", this.subAlarm, this.stats, this.emptyWindowObservations, this.emptyWindowObservationThreshold);
    }

    boolean evaluate(long now, long alarmDelay) {
        boolean immediateAlarmTransition;
        AlarmState newState;
        boolean shouldEvaluate = this.stats.shouldEvaluate(now, alarmDelay);
        if (this.immediateAlarmEvaluate()) {
            newState = AlarmState.ALARM;
        } else {
            if (!shouldEvaluate) {
                return false;
            }
            newState = this.determineAlarmStateUsingView();
        }
        boolean shouldSendStateChange = this.shouldSendStateChange(newState);
        boolean bl = immediateAlarmTransition = newState == AlarmState.ALARM && this.subAlarm.canEvaluateImmediately();
        if (shouldSendStateChange && (shouldEvaluate || immediateAlarmTransition)) {
            logger.debug("SubAlarm[deterministic={}] {} transitions from {} to {}", new Object[]{this.getSubAlarm().isDeterministic(), this.getSubAlarm().getId(), this.getSubAlarm().getState(), newState});
            this.setSubAlarmState(newState);
            return true;
        }
        return false;
    }

    private AlarmState determineAlarmStateUsingView() {
        boolean emptyWindowThresholdExceeded;
        double[] values;
        boolean thresholdExceeded = false;
        boolean hasEmptyWindows = false;
        this.subAlarm.clearCurrentValues();
        for (double value : values = this.stats.getViewValues()) {
            if (Double.isNaN(value)) {
                hasEmptyWindows = true;
                continue;
            }
            this.subAlarm.addCurrentValue(value);
            this.emptyWindowObservations = 0;
            if (!this.subAlarm.getExpression().getOperator().evaluate(value, this.subAlarm.getExpression().getThreshold())) {
                return AlarmState.OK;
            }
            thresholdExceeded = true;
        }
        if (thresholdExceeded && !hasEmptyWindows) {
            return AlarmState.ALARM;
        }
        ++this.emptyWindowObservations;
        boolean bl = emptyWindowThresholdExceeded = this.emptyWindowObservations >= this.emptyWindowObservationThreshold;
        if (emptyWindowThresholdExceeded && this.shouldSendStateChange(AlarmState.UNDETERMINED)) {
            boolean isDeterministic = this.subAlarm.isDeterministic();
            AlarmState state = SubAlarm.getDefaultState(isDeterministic);
            AlarmState subAlarmState = this.subAlarm.getState();
            logger.debug("SubAlarm[deterministic={}] {} exceeded empty window threshold {}, transition to {} from {}", new Object[]{isDeterministic, this.subAlarm.getId(), this.emptyWindowObservationThreshold, state, subAlarmState});
            return state;
        }
        return null;
    }

    private boolean immediateAlarmEvaluate() {
        if (!this.subAlarm.canEvaluateImmediately()) {
            return false;
        }
        double[] allValues = this.stats.getWindowValues();
        this.subAlarm.clearCurrentValues();
        int alarmRun = 0;
        for (double value : allValues) {
            if (Double.isNaN(value)) {
                alarmRun = 0;
                this.subAlarm.clearCurrentValues();
                continue;
            }
            if (!this.subAlarm.getExpression().getOperator().evaluate(value, this.subAlarm.getExpression().getThreshold())) {
                alarmRun = 0;
                this.subAlarm.clearCurrentValues();
                continue;
            }
            this.subAlarm.addCurrentValue(value);
            if (++alarmRun != this.subAlarm.getExpression().getPeriods()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldSendStateChange(AlarmState newState) {
        return newState != null && (!this.subAlarm.getState().equals((Object)newState) || this.subAlarm.isNoState());
    }

    private void setSubAlarmState(AlarmState newState) {
        this.subAlarm.setState(newState);
        this.subAlarm.setNoState(false);
    }

    public void updateSubAlarm(AlarmSubExpression newExpression, long viewEndTimestamp) {
        this.subAlarm.setNoState(true);
        boolean compatible = this.subAlarm.isCompatible(newExpression);
        this.subAlarm.setExpression(newExpression);
        if (!compatible) {
            logger.debug("Changing {} to {} and flushing measurements", (Object)this.subAlarm, (Object)this.subAlarm);
            this.initialize(this.subAlarm, TimeResolution.MINUTES, viewEndTimestamp);
        }
    }
}

