/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.Alarm;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.service.AlarmDAO;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDAOImpl
implements AlarmDAO {
    private static final Logger logger = LoggerFactory.getLogger(AlarmDAOImpl.class);
    public static final int MAX_COLUMN_LENGTH = 255;
    private final DBI db;

    @Inject
    public AlarmDAOImpl(DBI db) {
        this.db = db;
    }

    @Override
    public List<Alarm> findForAlarmDefinitionId(String alarmDefinitionId) {
        return this.findAlarms("a.alarm_definition_id = :alarmDefinitionId ", "alarmDefinitionId", alarmDefinitionId);
    }

    @Override
    public List<Alarm> listAll() {
        return this.findAlarms("1=1", new String[0]);
    }

    private List<Alarm> findAlarms(String additionalWhereClause, String ... params) {
        try (Handle h = this.db.open();){
            String ALARMS_SQL = "select a.id, a.alarm_definition_id, a.state, sa.id as sub_alarm_id, sa.expression, sa.sub_expression_id, ad.tenant_id from alarm a inner join sub_alarm sa on sa.alarm_id = a.id inner join alarm_definition ad on a.alarm_definition_id = ad.id where ad.deleted_at is null and %s order by a.id";
            String sql = String.format("select a.id, a.alarm_definition_id, a.state, sa.id as sub_alarm_id, sa.expression, sa.sub_expression_id, ad.tenant_id from alarm a inner join sub_alarm sa on sa.alarm_id = a.id inner join alarm_definition ad on a.alarm_definition_id = ad.id where ad.deleted_at is null and %s order by a.id", additionalWhereClause);
            Query query = h.createQuery(sql);
            this.addQueryParameters((Query<Map<String, Object>>)query, params);
            List rows = query.list();
            ArrayList<Alarm> alarms = new ArrayList<Alarm>(rows.size());
            ArrayList<SubAlarm> subAlarms = new ArrayList<SubAlarm>();
            String prevAlarmId = null;
            Alarm alarm = null;
            HashMap<String, Alarm> alarmMap = new HashMap<String, Alarm>();
            HashMap<String, String> tenantIdMap = new HashMap<String, String>();
            for (Map row : rows) {
                String alarmId = this.getString(row, "id");
                if (!alarmId.equals(prevAlarmId)) {
                    if (alarm != null) {
                        alarm.setSubAlarms(subAlarms);
                    }
                    alarm = new Alarm();
                    alarm.setId(alarmId);
                    alarm.setAlarmDefinitionId(this.getString(row, "alarm_definition_id"));
                    alarm.setState(AlarmState.valueOf((String)this.getString(row, "state")));
                    subAlarms = new ArrayList();
                    alarms.add(alarm);
                    alarmMap.put(alarmId, alarm);
                    tenantIdMap.put(alarmId, this.getString(row, "tenant_id"));
                }
                SubExpression subExpression = new SubExpression(this.getString(row, "sub_expression_id"), AlarmSubExpression.of((String)this.getString(row, "expression")));
                SubAlarm subAlarm = new SubAlarm(this.getString(row, "sub_alarm_id"), alarmId, subExpression);
                subAlarms.add(subAlarm);
                prevAlarmId = alarmId;
            }
            if (alarm != null) {
                alarm.setSubAlarms(subAlarms);
            }
            if (!alarms.isEmpty()) {
                this.getAlarmedMetrics(h, alarmMap, tenantIdMap, additionalWhereClause, params);
            }
            ArrayList<Alarm> arrayList = alarms;
            return arrayList;
        }
    }

    private void addQueryParameters(Query<Map<String, Object>> query, String ... params) {
        for (int i = 0; i < params.length; i += 2) {
            query.bind(params[i], params[i + 1]);
        }
    }

    private void getAlarmedMetrics(Handle h, Map<String, Alarm> alarmMap, Map<String, String> tenantIdMap, String additionalWhereClause, String ... params) {
        String baseSql = "select a.id, md.name, group_concat(mdim.name, '=', mdim.value order by mdim.name) as dimensions from metric_definition as md inner join metric_definition_dimensions as mdd on md.id = mdd.metric_definition_id inner join alarm_metric as am on mdd.id = am.metric_definition_dimensions_id inner join alarm as a on am.alarm_id = a.id left join metric_dimension as mdim on mdim.dimension_set_id = mdd.metric_dimension_set_id where %s group by a.id, md.name, mdim.dimension_set_id order by dimensions";
        String sql = String.format("select a.id, md.name, group_concat(mdim.name, '=', mdim.value order by mdim.name) as dimensions from metric_definition as md inner join metric_definition_dimensions as mdd on md.id = mdd.metric_definition_id inner join alarm_metric as am on mdd.id = am.metric_definition_dimensions_id inner join alarm as a on am.alarm_id = a.id left join metric_dimension as mdim on mdim.dimension_set_id = mdd.metric_dimension_set_id where %s group by a.id, md.name, mdim.dimension_set_id order by dimensions", additionalWhereClause);
        Query query = h.createQuery(sql);
        this.addQueryParameters((Query<Map<String, Object>>)query, params);
        List metricRows = query.list();
        for (Map row : metricRows) {
            String alarmId = this.getString(row, "id");
            Alarm alarm = alarmMap.get(alarmId);
            if (alarm == null) continue;
            MetricDefinition md = this.createMetricDefinitionFromRow(row);
            alarm.addAlarmedMetric(new MetricDefinitionAndTenantId(md, tenantIdMap.get(alarmId)));
        }
    }

    @Override
    public void addAlarmedMetric(String alarmId, MetricDefinitionAndTenantId metricDefinition) {
        try (Handle h = this.db.open();){
            h.begin();
            this.createAlarmedMetric(h, metricDefinition, alarmId);
            h.commit();
        }
    }

    private void createAlarmedMetric(Handle h, MetricDefinitionAndTenantId metricDefinition, String alarmId) {
        Sha1HashId metricDefinitionDimensionId = this.insertMetricDefinitionDimension(h, metricDefinition);
        h.insert("insert into alarm_metric (alarm_id, metric_definition_dimensions_id) values (?, ?)", new Object[]{alarmId, metricDefinitionDimensionId.getSha1Hash()});
    }

    private Sha1HashId insertMetricDefinitionDimension(Handle h, MetricDefinitionAndTenantId mdtid) {
        Sha1HashId metricDefinitionId = this.insertMetricDefinition(h, mdtid);
        Sha1HashId metricDimensionSetId = this.insertMetricDimensionSet(h, mdtid.metricDefinition.dimensions);
        byte[] definitionDimensionsIdSha1Hash = DigestUtils.sha((String)(metricDefinitionId.toHexString() + metricDimensionSetId.toHexString()));
        h.insert("insert into metric_definition_dimensions (id, metric_definition_id, metric_dimension_set_id) values (?, ?, ?)on duplicate key update id=id", new Object[]{definitionDimensionsIdSha1Hash, metricDefinitionId.getSha1Hash(), metricDimensionSetId.getSha1Hash()});
        return new Sha1HashId(definitionDimensionsIdSha1Hash);
    }

    private Sha1HashId insertMetricDimensionSet(Handle h, Map<String, String> dimensions) {
        byte[] dimensionSetId = this.calculateDimensionSHA1(dimensions);
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            h.insert("insert into metric_dimension(dimension_set_id, name, value) values (?, ?, ?) on duplicate key update dimension_set_id=dimension_set_id", new Object[]{dimensionSetId, entry.getKey(), entry.getValue()});
        }
        return new Sha1HashId(dimensionSetId);
    }

    private byte[] calculateDimensionSHA1(Map<String, String> dimensions) {
        StringBuilder dimensionIdStringToHash = new StringBuilder("");
        if (dimensions != null) {
            TreeMap<String, String> dimensionTreeMap = new TreeMap<String, String>(dimensions);
            for (String dimensionName : dimensionTreeMap.keySet()) {
                String dimensionValue;
                if (dimensionName == null || dimensionName.isEmpty() || (dimensionValue = dimensionTreeMap.get(dimensionName)) == null || dimensionValue.isEmpty()) continue;
                dimensionIdStringToHash.append(this.trunc(dimensionName, 255));
                dimensionIdStringToHash.append(this.trunc(dimensionValue, 255));
            }
        }
        byte[] dimensionIdSha1Hash = DigestUtils.sha((String)dimensionIdStringToHash.toString());
        return dimensionIdSha1Hash;
    }

    private Sha1HashId insertMetricDefinition(Handle h, MetricDefinitionAndTenantId mdtid) {
        String region = "";
        String definitionIdStringToHash = this.trunc(mdtid.metricDefinition.name, 255) + this.trunc(mdtid.tenantId, 255) + this.trunc("", 255);
        byte[] id = DigestUtils.sha((String)definitionIdStringToHash);
        h.insert("insert into metric_definition(id, name, tenant_id) values (?, ?, ?) on duplicate key update id=id", new Object[]{id, mdtid.metricDefinition.name, mdtid.tenantId});
        return new Sha1HashId(id);
    }

    @Override
    public void createAlarm(Alarm alarm) {
        try (Handle h = this.db.open();){
            h.begin();
            h.insert("insert into alarm (id, alarm_definition_id, state, state_updated_at, created_at, updated_at) values (?, ?, ?, NOW(), NOW(), NOW())", new Object[]{alarm.getId(), alarm.getAlarmDefinitionId(), alarm.getState().toString()});
            for (SubAlarm subAlarm : alarm.getSubAlarms()) {
                h.insert("insert into sub_alarm (id, alarm_id, sub_expression_id, expression, created_at, updated_at) values (?, ?, ?, ?, NOW(), NOW())", new Object[]{subAlarm.getId(), subAlarm.getAlarmId(), subAlarm.getAlarmSubExpressionId(), subAlarm.getExpression().getExpression()});
            }
            for (MetricDefinitionAndTenantId md : alarm.getAlarmedMetrics()) {
                this.createAlarmedMetric(h, md, alarm.getId());
            }
            h.commit();
        }
    }

    @Override
    public Alarm findById(String id) {
        List<Alarm> alarms = this.findAlarms("a.id = :alarm_id ", "alarm_id", id);
        if (alarms.isEmpty()) {
            return null;
        }
        return alarms.get(0);
    }

    @Override
    public void updateState(String id, AlarmState state) {
        try (Handle h = this.db.open();){
            ((Update)((Update)h.createStatement("update alarm set state = :state, state_updated_at = NOW(), updated_at = NOW() where id = :id").bind("id", id)).bind("state", state.toString())).execute();
        }
    }

    @Override
    public int updateSubAlarmExpressions(String alarmSubExpressionId, AlarmSubExpression alarmSubExpression) {
        try (Handle h = this.db.open();){
            int n = ((Update)((Update)h.createStatement("update sub_alarm set expression=:expression where sub_expression_id=:alarmSubExpressionId").bind("expression", alarmSubExpression.getExpression())).bind("alarmSubExpressionId", alarmSubExpressionId)).execute();
            return n;
        }
    }

    @Override
    public void deleteByDefinitionId(String alarmDefinitionId) {
        try (Handle h = this.db.open();){
            h.execute("delete from alarm where alarm_definition_id = :id", new Object[]{alarmDefinitionId});
        }
    }

    private MetricDefinition createMetricDefinitionFromRow(Map<String, Object> row) {
        HashMap<String, String> dimensionMap = new HashMap<String, String>();
        String dimensions = this.getString(row, "dimensions");
        if (dimensions != null) {
            for (String dimension : dimensions.split(",")) {
                String[] parsed_dimension = dimension.split("=");
                dimensionMap.put(parsed_dimension[0], parsed_dimension[1]);
            }
        }
        MetricDefinition md = new MetricDefinition(this.getString(row, "name"), dimensionMap);
        return md;
    }

    private String getString(Map<String, Object> row, String fieldName) {
        return (String)row.get(fieldName);
    }

    private String trunc(String s, int l) {
        if (s == null) {
            return "";
        }
        if (s.length() <= l) {
            return s;
        }
        String r = s.substring(0, l);
        logger.warn("Input string exceeded max column length. Truncating input string {} to {} chars", (Object)s, (Object)l);
        logger.warn("Resulting string {}", (Object)r);
        return r;
    }

    private static class Sha1HashId {
        private final byte[] sha1Hash;

        public Sha1HashId(byte[] sha1Hash) {
            this.sha1Hash = sha1Hash;
        }

        public String toString() {
            return "Sha1HashId{sha1Hash=" + Hex.encodeHexString((byte[])this.sha1Hash) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sha1HashId)) {
                return false;
            }
            Sha1HashId that = (Sha1HashId)o;
            return Arrays.equals(this.sha1Hash, that.sha1Hash);
        }

        public int hashCode() {
            return Arrays.hashCode(this.sha1Hash);
        }

        public byte[] getSha1Hash() {
            return this.sha1Hash;
        }

        public String toHexString() {
            return Hex.encodeHexString((byte[])this.sha1Hash);
        }
    }
}

