/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.persistence.hibernate;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.AlarmMetricDb;
import monasca.common.hibernate.db.MetricDefinitionDb;
import monasca.common.hibernate.db.MetricDefinitionDimensionsDb;
import monasca.common.hibernate.db.MetricDimensionDb;
import monasca.common.hibernate.db.SubAlarmDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.hibernate.type.BinaryId;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.thresh.domain.model.Alarm;
import monasca.thresh.domain.model.MetricDefinitionAndTenantId;
import monasca.thresh.domain.model.SubAlarm;
import monasca.thresh.domain.model.SubExpression;
import monasca.thresh.domain.service.AlarmDAO;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmSqlImpl
implements AlarmDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmSqlImpl.class);
    private static final int ALARM_ID = 0;
    private static final int ALARM_DEFINITION_ID = 1;
    private static final int ALARM_STATE = 2;
    private static final int SUB_ALARM_ID = 3;
    private static final int ALARM_EXPRESSION = 4;
    private static final int SUB_EXPRESSION_ID = 5;
    private static final int TENANT_ID = 6;
    private static final int MAX_COLUMN_LENGTH = 255;
    private final SessionFactory sessionFactory;

    @Inject
    public AlarmSqlImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Alarm findById(final String id) {
        List<Alarm> alarms = this.findAlarms(new LookupHelper(){

            @Override
            public Criteria apply(@Nonnull Criteria input) {
                return input.add((Criterion)Restrictions.eq((String)"a.id", (Object)id));
            }

            @Override
            public Query apply(@Nonnull Query query) {
                return query.setParameter("alarmId", (Object)id);
            }

            @Override
            public String formatHQL(@Nonnull String hqlQuery) {
                return String.format(hqlQuery, "a.id=:alarmId");
            }
        });
        return alarms.isEmpty() ? null : alarms.get(0);
    }

    @Override
    public List<Alarm> findForAlarmDefinitionId(final String alarmDefinitionId) {
        return this.findAlarms(new LookupHelper(){

            @Override
            public Criteria apply(@Nonnull Criteria input) {
                return input.add((Criterion)Restrictions.eq((String)"a.alarmDefinition.id", (Object)alarmDefinitionId));
            }

            @Override
            public Query apply(@Nonnull Query query) {
                return query.setParameter("alarmDefinitionId", (Object)alarmDefinitionId);
            }

            @Override
            public String formatHQL(@Nonnull String hqlQuery) {
                return String.format(hqlQuery, "a.alarmDefinition.id=:alarmDefinitionId");
            }
        });
    }

    @Override
    public List<Alarm> listAll() {
        return this.findAlarms(LookupHelper.NOOP_HELPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateState(String id, AlarmState state) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            DateTime now = DateTime.now();
            AlarmDb alarm = (AlarmDb)session.get(AlarmDb.class, (Serializable)((Object)id));
            alarm.setState(state);
            alarm.setUpdatedAt(now);
            alarm.setStateUpdatedAt(now);
            session.update((Object)alarm);
            tx.commit();
            tx = null;
            this.rollbackIfNotNull(tx);
            if (session == null) return;
        }
        catch (Throwable throwable) {
            this.rollbackIfNotNull(tx);
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addAlarmedMetric(String id, MetricDefinitionAndTenantId metricDefinition) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            this.createAlarmedMetric(session, metricDefinition, id);
            tx.commit();
            tx = null;
            this.rollbackIfNotNull(tx);
            if (session == null) return;
        }
        catch (Throwable throwable) {
            this.rollbackIfNotNull(tx);
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createAlarm(Alarm newAlarm) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            DateTime now = DateTime.now();
            AlarmDb alarm = new AlarmDb(newAlarm.getId(), (AlarmDefinitionDb)session.get(AlarmDefinitionDb.class, (Serializable)((Object)newAlarm.getAlarmDefinitionId())), newAlarm.getState(), null, null, now, now, now);
            session.save((Object)alarm);
            for (SubAlarm subAlarm : newAlarm.getSubAlarms()) {
                session.save((Object)new SubAlarmDb().setAlarm(alarm).setSubExpression((SubAlarmDefinitionDb)session.get(SubAlarmDefinitionDb.class, (Serializable)((Object)subAlarm.getAlarmSubExpressionId()))).setExpression(subAlarm.getExpression().getExpression()).setUpdatedAt(now).setCreatedAt(now).setId((Serializable)((Object)subAlarm.getId())));
            }
            for (MetricDefinitionAndTenantId md : newAlarm.getAlarmedMetrics()) {
                this.createAlarmedMetric(session, md, newAlarm.getId());
            }
            tx.commit();
            tx = null;
            this.rollbackIfNotNull(tx);
            if (session == null) return;
        }
        catch (Throwable throwable) {
            this.rollbackIfNotNull(tx);
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateSubAlarmExpressions(String alarmSubExpressionId, AlarmSubExpression alarmSubExpression) {
        int n;
        block3: {
            Transaction tx = null;
            Session session = null;
            try {
                session = this.sessionFactory.openSession();
                tx = session.beginTransaction();
                int updatedItems = session.getNamedQuery("SubAlarm.updateExpressionBySubexpressionId").setString("expression", alarmSubExpression.getExpression()).setString("alarmSubExpressionId", alarmSubExpressionId).executeUpdate();
                tx.commit();
                tx = null;
                n = updatedItems;
                this.rollbackIfNotNull(tx);
                if (session == null) break block3;
            }
            catch (Throwable throwable) {
                this.rollbackIfNotNull(tx);
                if (session != null) {
                    session.close();
                }
                throw throwable;
            }
            session.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteByDefinitionId(String alarmDefinitionId) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            session.getNamedQuery("Alarm.deleteByAlarmDefinitionId").setString("alarmDefinitionId", alarmDefinitionId).executeUpdate();
            tx.commit();
            tx = null;
            this.rollbackIfNotNull(tx);
            if (session == null) return;
        }
        catch (Throwable throwable) {
            this.rollbackIfNotNull(tx);
            if (session == null) throw throwable;
            session.close();
            throw throwable;
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Alarm> findAlarms(@Nonnull LookupHelper lookupHelper) {
        try (StatelessSession session = null;){
            session = this.sessionFactory.openStatelessSession();
            Criteria criteria = lookupHelper.apply(session.createCriteria(AlarmDb.class, "a").createAlias("a.subAlarms", "sa").createAlias("a.alarmDefinition", "ad").add(Restrictions.isNull((String)"ad.deletedAt")).addOrder(Order.asc((String)"a.id")).setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"a.id")).add((Projection)Projections.property((String)"a.alarmDefinition.id")).add((Projection)Projections.property((String)"a.state")).add(Projections.alias((Projection)Projections.property((String)"sa.id"), (String)"sub_alarm_id")).add((Projection)Projections.property((String)"sa.expression")).add((Projection)Projections.property((String)"sa.subExpression.id")).add((Projection)Projections.property((String)"ad.tenantId"))).setReadOnly(true));
            assert (criteria != null);
            List<Alarm> list = this.createAlarms(session, criteria.list(), lookupHelper);
            return list;
        }
    }

    private Map<String, List<MetricDefinition>> getAlarmedMetrics(List<Object[]> alarmList) {
        HashMap result = Maps.newHashMap();
        HashMap metricDefinitionList = Maps.newHashMap();
        HashMap metricList = Maps.newHashMap();
        HashMap mapAssociationIds = Maps.newHashMap();
        for (Object[] alarmRow : alarmList) {
            Map dimensions;
            String alarmId = (String)alarmRow[0];
            String metric_name = (String)alarmRow[1];
            String dimension_name = (String)alarmRow[2];
            String dimension_value = (String)alarmRow[3];
            BinaryId dimensionSetId = (BinaryId)alarmRow[4];
            if (!metricList.containsKey(dimensionSetId)) {
                metricList.put(dimensionSetId, new HashMap());
            }
            if (!(dimensions = (Map)metricList.get(dimensionSetId)).containsKey(metric_name)) {
                dimensions.put(metric_name, new HashMap());
            }
            if (!mapAssociationIds.containsKey(alarmId)) {
                mapAssociationIds.put(alarmId, new HashSet());
            }
            ((Set)mapAssociationIds.get(alarmId)).add(dimensionSetId);
            ((Map)dimensions.get(metric_name)).put(dimension_name, dimension_value);
        }
        for (BinaryId keyDimensionSetId : metricList.keySet()) {
            Map metrics = (Map)metricList.get(keyDimensionSetId);
            ArrayList valueList = Lists.newArrayListWithExpectedSize((int)metrics.size());
            for (String keyMetricName : metrics.keySet()) {
                MetricDefinition md = new MetricDefinition(keyMetricName, (Map)metrics.get(keyMetricName));
                valueList.add(md);
            }
            metricDefinitionList.put(keyDimensionSetId, valueList);
        }
        for (String keyAlarmId : mapAssociationIds.keySet()) {
            if (!result.containsKey(keyAlarmId)) {
                result.put(keyAlarmId, new LinkedList());
            }
            Set setDimensionId = (Set)mapAssociationIds.get(keyAlarmId);
            for (BinaryId keyDimensionId : setDimensionId) {
                List metricDefList = (List)metricDefinitionList.get(keyDimensionId);
                ((List)result.get(keyAlarmId)).addAll(metricDefList);
            }
        }
        return result;
    }

    private List<Alarm> createAlarms(StatelessSession session, List<Object[]> alarmList, LookupHelper lookupHelper) {
        ArrayList alarms = Lists.newArrayListWithCapacity((int)alarmList.size());
        if (alarmList.isEmpty()) {
            return alarms;
        }
        List subAlarms = null;
        String prevAlarmId = null;
        Alarm alarm = null;
        HashMap alarmMap = Maps.newHashMapWithExpectedSize((int)alarmList.size());
        HashMap tenantIdMap = Maps.newHashMapWithExpectedSize((int)alarmList.size());
        for (Object[] alarmRow : alarmList) {
            String alarmId = (String)alarmRow[0];
            if (!alarmId.equals(prevAlarmId)) {
                if (alarm != null) {
                    alarm.setSubAlarms(subAlarms);
                }
                alarm = new Alarm();
                alarm.setId(alarmId);
                alarm.setAlarmDefinitionId((String)alarmRow[1]);
                alarm.setState((AlarmState)alarmRow[2]);
                subAlarms = Lists.newArrayListWithExpectedSize((int)alarmList.size());
                alarms.add(alarm);
                alarmMap.put(alarmId, alarm);
                tenantIdMap.put(alarmId, (String)alarmRow[6]);
            }
            subAlarms.add(new SubAlarm((String)alarmRow[3], alarmId, new SubExpression((String)alarmRow[5], AlarmSubExpression.of((String)((String)alarmRow[4])))));
            prevAlarmId = alarmId;
        }
        if (alarm != null) {
            alarm.setSubAlarms(subAlarms);
        }
        if (!alarms.isEmpty()) {
            this.getAlarmedMetrics(session, alarmMap, tenantIdMap, lookupHelper);
        }
        return alarms;
    }

    private void getAlarmedMetrics(StatelessSession session, Map<String, Alarm> alarmMap, Map<String, String> tenantIdMap, LookupHelper binder) {
        String rawHQLQuery = "select a.id, md.name as metric_def_name, mdg.id.name, mdg.value, mdg.id.dimensionSetId from MetricDefinitionDb as md, MetricDefinitionDimensionsDb as mdd, AlarmMetricDb as am, AlarmDb as a, MetricDimensionDb as mdg where md.id = mdd.metricDefinition.id and mdd.id = am.alarmMetricId.metricDefinitionDimensions.id and am.alarmMetricId.alarm.id = a.id and mdg.id.dimensionSetId = mdd.metricDimensionSetId and %s";
        Query query = binder.apply(session.createQuery(binder.formatHQL(rawHQLQuery)));
        List metricRows = query.list();
        HashSet existingAlarmId = Sets.newHashSet();
        Map<String, List<MetricDefinition>> alarmMetrics = this.getAlarmedMetrics(metricRows);
        for (Object[] row : metricRows) {
            String alarmId = (String)row[0];
            Alarm alarm = alarmMap.get(alarmId);
            if (alarm == null) continue;
            if (!existingAlarmId.contains(alarmId)) {
                List<MetricDefinition> mdList = alarmMetrics.get(alarmId);
                for (MetricDefinition md : mdList) {
                    alarm.addAlarmedMetric(new MetricDefinitionAndTenantId(md, tenantIdMap.get(alarmId)));
                }
            }
            existingAlarmId.add(alarmId);
        }
    }

    private AlarmMetricDb createAlarmedMetric(Session session, MetricDefinitionAndTenantId metricDefinition, String alarmId) {
        MetricDefinitionDimensionsDb metricDefinitionDimension = this.insertMetricDefinitionDimension(session, metricDefinition);
        AlarmDb alarm = (AlarmDb)session.load(AlarmDb.class, (Serializable)((Object)alarmId));
        AlarmMetricDb alarmMetric = new AlarmMetricDb(alarm, metricDefinitionDimension);
        session.save((Object)alarmMetric);
        return alarmMetric;
    }

    private MetricDefinitionDimensionsDb insertMetricDefinitionDimension(Session session, MetricDefinitionAndTenantId mdtId) {
        MetricDefinitionDb metricDefinition = this.insertMetricDefinition(session, mdtId);
        BinaryId metricDimensionSetId = this.insertMetricDimensionSet(session, mdtId.metricDefinition.dimensions);
        byte[] definitionDimensionsIdSha1Hash = DigestUtils.sha((String)(metricDefinition.getId().toHexString() + metricDimensionSetId.toHexString()));
        MetricDefinitionDimensionsDb metricDefinitionDimensions = new MetricDefinitionDimensionsDb(definitionDimensionsIdSha1Hash, metricDefinition, metricDimensionSetId);
        return (MetricDefinitionDimensionsDb)session.merge((Object)metricDefinitionDimensions);
    }

    private BinaryId insertMetricDimensionSet(Session session, Map<String, String> dimensions) {
        byte[] dimensionSetId = this.calculateDimensionSHA1(dimensions);
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            MetricDimensionDb metricDimension = new MetricDimensionDb(dimensionSetId, entry.getKey(), entry.getValue());
            if (session.get(MetricDimensionDb.class, (Serializable)metricDimension.getId()) != null) continue;
            session.merge((Object)metricDimension);
        }
        return new BinaryId(dimensionSetId);
    }

    private MetricDefinitionDb insertMetricDefinition(Session session, MetricDefinitionAndTenantId mdtid) {
        String region = "";
        String definitionIdStringToHash = this.truncateString(mdtid.metricDefinition.name, 255) + this.truncateString(mdtid.tenantId, 255) + this.truncateString("", 255);
        byte[] id = DigestUtils.sha((String)definitionIdStringToHash);
        MetricDefinitionDb metricDefinition = new MetricDefinitionDb(id, mdtid.metricDefinition.name, mdtid.tenantId, "");
        if (session.get(MetricDefinitionDb.class, (Serializable)metricDefinition.getId()) == null) {
            session.persist((Object)metricDefinition);
            return metricDefinition;
        }
        session.merge((Object)metricDefinition);
        return metricDefinition;
    }

    private String truncateString(String s, int l) {
        if (s == null) {
            return "";
        }
        if (s.length() <= l) {
            return s;
        }
        String r = s.substring(0, l);
        LOGGER.warn("Input string exceeded max column length. Truncating input string {} to {} chars", (Object)s, (Object)l);
        LOGGER.warn("Resulting string {}", (Object)r);
        return r;
    }

    private byte[] calculateDimensionSHA1(Map<String, String> dimensions) {
        StringBuilder dimensionIdStringToHash = new StringBuilder("");
        if (dimensions != null && !dimensions.isEmpty()) {
            TreeMap dimensionTreeMap = Maps.newTreeMap((SortedMap)ImmutableSortedMap.copyOf(dimensions));
            for (String dimensionName : dimensionTreeMap.keySet()) {
                String dimensionValue;
                if (dimensionName == null || dimensionName.isEmpty() || (dimensionValue = (String)dimensionTreeMap.get(dimensionName)) == null || dimensionValue.isEmpty()) continue;
                dimensionIdStringToHash.append(this.truncateString(dimensionName, 255)).append(this.truncateString(dimensionValue, 255));
            }
        }
        return DigestUtils.sha((String)dimensionIdStringToHash.toString());
    }

    private void rollbackIfNotNull(Transaction tx) {
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (RuntimeException rbe) {
                LOGGER.error("Couldn\u2019t roll back transaction", (Throwable)rbe);
            }
        }
    }

    private static class LookupHelper {
        static final LookupHelper NOOP_HELPER = new LookupHelper();

        private LookupHelper() {
        }

        public Criteria apply(@Nonnull Criteria input) {
            return input;
        }

        public Query apply(@Nonnull Query query) {
            return query;
        }

        public String formatHQL(@Nonnull String hqlQuery) {
            return String.format(hqlQuery, "1=1");
        }
    }
}

