/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.utils;

import backtype.storm.metric.api.IMetricsConsumer;
import backtype.storm.task.IErrorReporter;
import backtype.storm.task.TopologyContext;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.timgroup.statsd.NonBlockingUdpSender;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import monasca.common.streaming.storm.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdMetricConsumer
implements IMetricsConsumer {
    public static final String STATSD_HOST = "metrics.statsd.host";
    public static final String STATSD_PORT = "metrics.statsd.port";
    public static final String STATSD_METRICMAP = "metrics.statsd.metricmap";
    public static final String STATSD_WHITELIST = "metrics.statsd.whitelist";
    public static final String STATSD_DIMENSIONS = "metrics.statsd.dimensions";
    public static final String STATSD_DEBUGMETRICS = "metrics.statsd.debugmetrics";
    private String topologyName;
    private String statsdHost = "localhost";
    private int statsdPort = 8125;
    private String monascaStatsdDimPrefix = "|#";
    private List<String> whiteList = new ArrayList<String>();
    private Map<String, String> metricMap = new HashMap<String, String>();
    private Boolean debugMetrics = false;
    String defaultDimensions;
    String statsdDimensions = this.defaultDimensions = this.monascaStatsdDimPrefix + "{\"service\":\"monitoring\",\"component\":\"storm\"}";
    transient NonBlockingUdpSender udpclient;
    private transient StatsDClientErrorHandler handler;
    private transient Logger logger;
    StatsDClientErrorHandler statsdErrorHandler = new StatsDClientErrorHandler(){

        public void handle(Exception e) {
            StatsdMetricConsumer.this.logger.error("Error with StatsD UDP client! {}", (Throwable)e);
        }
    };

    public void prepare(Map stormConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        this.logger = LoggerFactory.getLogger((String)Logging.categoryFor(this.getClass(), (TopologyContext)context));
        this.parseConfig(stormConf);
        if (registrationArgument instanceof Map) {
            this.parseConfig((Map)registrationArgument);
        }
        this.initClient();
        this.logger.info("topologyName ({}), clean(topologyName) ({})", new Object[]{this.topologyName, this.clean(this.topologyName)});
    }

    private void initClient() {
        try {
            this.handler = this.statsdErrorHandler;
            this.udpclient = new NonBlockingUdpSender(this.statsdHost, this.statsdPort, Charset.defaultCharset(), this.handler);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
        }
    }

    void parseConfig(Map<?, ?> conf) {
        if (conf.containsKey("topology.name")) {
            this.topologyName = (String)conf.get("topology.name");
        }
        if (conf.containsKey(STATSD_HOST)) {
            this.statsdHost = (String)conf.get(STATSD_HOST);
        }
        if (conf.containsKey(STATSD_PORT)) {
            this.statsdPort = ((Number)conf.get(STATSD_PORT)).intValue();
        }
        if (conf.containsKey(STATSD_DIMENSIONS)) {
            this.statsdDimensions = this.mapToJsonStr((Map)conf.get(STATSD_DIMENSIONS));
            if (!this.isValidJSON(this.statsdDimensions)) {
                this.logger.error("Ignoring dimensions element invalid JSON ({})", new Object[]{this.statsdDimensions});
                this.statsdDimensions = this.monascaStatsdDimPrefix + this.defaultDimensions;
            } else {
                this.statsdDimensions = this.monascaStatsdDimPrefix + this.statsdDimensions;
            }
        }
        if (conf.containsKey(STATSD_WHITELIST)) {
            this.whiteList = (List)conf.get(STATSD_WHITELIST);
        }
        if (conf.containsKey(STATSD_METRICMAP)) {
            this.metricMap = (Map)conf.get(STATSD_METRICMAP);
        }
        if (conf.containsKey(STATSD_DEBUGMETRICS)) {
            this.debugMetrics = (Boolean)conf.get(STATSD_DEBUGMETRICS);
        }
    }

    private String mapToJsonStr(Map<String, String> inputMap) {
        String results = new String();
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, inputMap);
            results = sw.toString();
        }
        catch (JsonGenerationException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error("{}", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
        }
        return results;
    }

    private boolean isValidJSON(String json) {
        boolean valid = false;
        try {
            JsonParser parser = new ObjectMapper().getFactory().createParser(json);
            while (parser.nextToken() != null) {
            }
            valid = true;
        }
        catch (JsonParseException jpe) {
            valid = false;
        }
        catch (IOException ioe) {
            valid = false;
        }
        return valid;
    }

    String clean(String s) {
        return s.replace('.', '_').replace('/', '_').replace(':', '_').replaceAll("__", "");
    }

    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        for (Metric metric : this.dataPointsToMetrics(taskInfo, dataPoints)) {
            this.reportUOM(metric.name, metric.value);
        }
    }

    private List<Metric> dataPointsToMetrics(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        LinkedList<Metric> res = new LinkedList<Metric>();
        StringBuilder sb = new StringBuilder().append(this.clean(taskInfo.srcComponentId)).append(".");
        int hdrLength = sb.length();
        for (IMetricsConsumer.DataPoint p : dataPoints) {
            sb.delete(hdrLength, sb.length());
            sb.append(this.clean(p.name));
            this.logger.debug("Storm StatsD metric p.name ({}) p.value ({})", new Object[]{p.name, p.value});
            if (p.value instanceof Number) {
                res.add(new Metric(sb.toString(), ((Number)p.value).doubleValue()));
                continue;
            }
            if (!(p.value instanceof Map) || ((Map)p.value).isEmpty()) continue;
            int hdrAndNameLength = sb.length();
            Map map = (Map)p.value;
            for (Object subName : map.keySet()) {
                Object subValue = map.get(subName);
                if (!(subValue instanceof Number)) continue;
                sb.delete(hdrAndNameLength, sb.length());
                sb.append(".").append(this.clean(subName.toString()));
                res.add(new Metric(sb.toString(), ((Number)subValue).doubleValue()));
            }
        }
        return res;
    }

    public void report(String s) {
        if (this.udpclient != null) {
            this.logger.debug("reporting: {}", (Object)s);
            this.udpclient.send(s);
        } else {
            this.initClient();
        }
    }

    private void reportUOM(String s, Double number) {
        String metricName = null;
        StringBuilder results = new StringBuilder();
        Boolean published = false;
        if (this.whiteList.contains(s) && (metricName = !this.metricMap.isEmpty() && this.metricMap.containsKey(s) ? this.metricMap.get(s) : s) != null && !metricName.isEmpty()) {
            published = true;
        }
        if (this.debugMetrics.booleanValue()) {
            String mappedName = new String();
            mappedName = !this.metricMap.isEmpty() && this.metricMap.containsKey(s) ? this.metricMap.get(s) : s;
            this.logger.info(", RawMetricName, {}, MappedMetricName, {}, val, {}, {}", new Object[]{s, mappedName, number, published == true ? "PUBLISHED" : "UNPUBLISHED"});
        }
        if (published.booleanValue()) {
            results = results.append(metricName).append(":").append(String.valueOf(number)).append("|c").append(this.statsdDimensions);
            this.report(results.toString());
        }
    }

    public void cleanup() {
        this.udpclient.stop();
    }

    public static class Metric {
        String name;
        Double value;

        public Metric(String name, Double value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Metric other = (Metric)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.value == other.value;
        }

        public String toString() {
            return "Metric [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

