/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFinder {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFinder.class);

    private PropertyFinder() {
    }

    public static int getIntProperty(String name, int defaultValue, int minValue, int maxValue) {
        String valueString = System.getProperty(name);
        if (valueString != null && !valueString.isEmpty()) {
            try {
                int newValue = Integer.parseInt(valueString);
                if (newValue >= minValue && newValue <= maxValue) {
                    return newValue;
                }
                logger.warn("Invalid value {} for property '{}' must be >= {} and <= {}, using default value of {}", new Object[]{valueString, name, minValue, maxValue, defaultValue});
            }
            catch (NumberFormatException nfe) {
                logger.warn("Not an integer value '{}' for property '{}', using default value of {}", new Object[]{valueString, name, defaultValue});
            }
        }
        return defaultValue;
    }
}

