/*
 * Decompiled with CFR 0.152.
 */
package monasca.thresh.infrastructure.thresholding;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import monasca.common.configuration.KafkaProducerConfiguration;
import monasca.common.configuration.KafkaProducerProperties;
import monasca.thresh.infrastructure.thresholding.AlarmEventForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAlarmEventForwarder
implements AlarmEventForwarder {
    private static final Logger logger = LoggerFactory.getLogger(KafkaAlarmEventForwarder.class);
    private final Producer<String, String> producer;
    private final String topic;
    private long messageCount = 0L;

    public KafkaAlarmEventForwarder(KafkaProducerConfiguration kafkaConfig) {
        this.topic = kafkaConfig.getTopic();
        Properties kafkaProperties = KafkaProducerProperties.createKafkaProperties((KafkaProducerConfiguration)kafkaConfig);
        ProducerConfig consumerConfig = new ProducerConfig(kafkaProperties);
        this.producer = new Producer(consumerConfig);
    }

    @Override
    public void send(String json) {
        logger.debug("sending topic: {}, json: {}", (Object)this.topic, (Object)json);
        String routingKey = String.valueOf(this.messageCount++);
        KeyedMessage message = new KeyedMessage(this.topic, (Object)routingKey, (Object)json);
        this.producer.send(message);
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

