import os

import setuptools

from cinder.openstack.common.setup import parse_requirements
from cinder.openstack.common.setup import parse_dependency_links
from cinder.openstack.common.setup import write_git_changelog


requires = parse_requirements()
dependency_links = parse_dependency_links()
write_git_changelog()


def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setuptools.setup(
    name="cinder",
    version="2012.2",
    description="Block storage system for OpenStack Nova",
    long_description=read('README.rst'),
    url='https://github.com/openstack/cinder',
    license='Apache',
    author='OpenStack Cinder Contributors',
    author_email='cinder@example.com',
    packages=setuptools.find_packages(exclude=['tests', 'tests.*']),
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
    ],
    install_requires=requires,
    dependency_links=dependency_links,
    test_suite="nose.collector",
)
