# Copyright 2011 OpenStack LLC.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from cinder import flags
from cinder.openstack.common import log as logging
from cinder.openstack.common import jsonutils


FLAGS = flags.FLAGS


def notify(message):
    """Notifies the recipient of the desired event given the model.
    Log notifications using cinder's default logging system"""

    priority = message.get('priority',
                           FLAGS.default_notification_level)
    priority = priority.lower()
    logger = logging.getLogger(
            'cinder.notification.%s' % message['event_type'])
    getattr(logger, priority)(jsonutils.dumps(message))
